/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: DateTime.cpp,v 1.9 2004/07/04 12:32:36 randy Exp $
 */

#include <time.h>
#include "soopy.h"

void SpDateTime::regular()
{
    // time
    SpInt i = 0;
    SpTime* t = time.asTime();
    t->regular();
    if(t->hour < 0){
        while(t->hour < 0){
            t->hour += 24;
            i--;
        }
    }else if(t->hour > 24){
        while(t->hour > 24){
            t->hour -= 24;
            i++;
        }
    }
    // date
    SpDate* d = date.asDate();
    d->day += i;
    d->regular();
}

SpValue& SpDateTime::plus(SpValue& e1, SpValue& e2)
{
    SpDateTime* dt = e1.asDateTime();
    SpDateTime* date;
    if(e2.isInt()){
        SpDate* d1 = dt->date.asDate();
        SpTime* t1 = dt->time.asTime();
        SpInt i = e2.getInt();
        date = new SpDateTime(d1->year,
                              d1->month,
                              d1->day,
                              t1->hour,
                              t1->minute,
                              t1->second + i);
/*
    }else if(e2.isDateTime()){
        SpDateTime* dt2 = e2.asDateTime();
        SpDate* d1 = dt->date.asDate();
        SpTime* t1 = dt->time.asTime();
        SpDate* d2 = dt2->date.asDate();
        SpTime* t2 = dt2->time.asTime();
        date = new SpDateTime(d1->year   + d2->year,
                              d1->month  + d2->month,
                              d1->day    + d2->day,
                              t1->hour   + t2->hour,
                              t1->minute + t2->minute,
                              t1->second + t2->second);
*/
    }else{
        throw SpException("not int datetime::operator+");
    }
    date->regular();
    //    static SpValue result;
    //    result.setNewObject(date);
    //    return result;
    return SpObjectResult(date);
}

SpValue& SpDateTime::minus(SpValue& e1, SpValue& e2)
{
    SpDateTime* dt = e1.asDateTime();
    SpDateTime* date;
    if(e2.isInt()){
        SpDate* d1 = dt->date.asDate();
        SpTime* t1 = dt->time.asTime();
        SpInt i = e2.getInt();
        date = new SpDateTime(d1->year,
                              d1->month,
                              d1->day,
                              t1->hour,
                              t1->minute,
                              t1->second - i);
/*
    }else if(e2.isDateTime()){
        SpDateTime* dt2 = e2.asDateTime();
        SpDate* d1 = dt->date.asDate();
        SpTime* t1 = dt->time.asTime();
        SpDate* d2 = dt2->date.asDate();
        SpTime* t2 = dt2->time.asTime();
        date = new SpDateTime(d1->year   - d2->year,
                              d1->month  - d2->month,
                              d1->day    - d2->day,
                              t1->hour   - t2->hour,
                              t1->minute - t2->minute,
                              t1->second - t2->second);
*/
    }else{
        throw SpException("not int datetime::operator-");
    }
    date->regular();
    return SpObjectResult(date);
}

SpValue& SpDateTime::eq(SpValue& e1, SpValue& e2)
{
    if(!e2.isDateTime()){
        return SpBoolResult(false);
    }
    SpDateTime* t1 = e1.asDateTime();
    SpDateTime* t2 = e2.asDateTime();
    return boolAnd(t1->date.eq(t2->date), t1->time.eq(t2->time));
}

SpValue& SpDateTime::ne(SpValue& e1, SpValue& e2)
{
    if(!e2.isDateTime()){
        return SpBoolResult(true);
    }
    SpDateTime* t1 = e1.asDateTime();
    SpDateTime* t2 = e2.asDateTime();
    return boolOr(t1->date.ne(t2->date), t1->time.ne(t2->time));
}

SpValue& SpDateTime::gt(SpValue& e1, SpValue& e2)
{
    if(!e2.isDateTime()){
        throw SpException("unmatch type (DateTime >)");
    }
    SpDateTime* t1 = e1.asDateTime();
    SpDateTime* t2 = e2.asDateTime();
    if(t1->date.gt(t2->date).isTrue()){
        return SpBoolResult(true);
    }else if(t1->date.eq(t2->date).isTrue()){
        return t1->time.gt(t2->time);
    }
    return SpBoolResult(false);
}

SpValue& SpDateTime::ge(SpValue& e1, SpValue& e2)
{
    if(!e2.isDateTime()){
        throw SpException("unmatch type (>=)");
    }
    SpDateTime* t1 = e1.asDateTime();
    SpDateTime* t2 = e2.asDateTime();
    if(t1->date.gt(t2->date).isTrue()){
        return SpBoolResult(true);
    }else if(t1->date.eq(t2->date).isTrue()){
        return t1->time.ge(t2->time);
    }
    return SpBoolResult(false);
}

SpValue& SpDateTime::lt(SpValue& e1, SpValue& e2)
{
    if(!e2.isDateTime()){
        throw SpException("unmatch type (<)");
    }
    SpDateTime* t1 = e1.asDateTime();
    SpDateTime* t2 = e2.asDateTime();
    if(t1->date.lt(t2->date).isTrue()){
        return SpBoolResult(true);
    }else if(t1->date.eq(t2->date).isTrue()){
        return t1->time.lt(t2->time);
    }
    return SpBoolResult(false);
}

SpValue& SpDateTime::le(SpValue& e1, SpValue& e2)
{
    if(!e2.isDateTime()){
        throw SpException("unmatch type (<=)");
    }
    SpDateTime* t1 = e1.asDateTime();
    SpDateTime* t2 = e2.asDateTime();
    if(t1->date.lt(t2->date).isTrue()){
        return SpBoolResult(true);
    }else if(t1->date.eq(t2->date).isTrue()){
        return t1->time.le(t2->time);
    }
    return SpBoolResult(false);
}

SpValue& SpDateTime::toString()
{
    char buf[10];
    SpDate* d1 = date.asDate();
    SpTime* t1 = time.asTime();
    SpString* str = new SpString;
    sprintf(buf, "%d", d1->year);
    *str += buf;
    sprintf(buf, "-%02d", d1->month);
    *str += buf;
    sprintf(buf, "-%02d ", d1->day);
    *str += buf;
    sprintf(buf, "%02d", t1->hour);
    *str += buf;
    sprintf(buf, ":%02d", t1->minute);
    *str += buf;
    sprintf(buf, ":%02d", t1->second);
    *str += buf;
    //    static SpValue val;
    //    val.setNewObject(str);
    //    return val;
    return SpObjectResult(str);
}

void SpDateTime::assign(SpValue& feature, SpValue& value)
{
    SpValue v;

    if(feature == SymYear){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign datetime)");
        }
        SpDate* d1 = date.asDate();
        d1->year = v.getInt();
    }else if(feature == SymMonth){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign datetime)");
        }
        SpDate* d1 = date.asDate();
        d1->month = v.getInt();
    }else if(feature == SymDay){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign datetime)");
        }
        SpDate* d1 = date.asDate();
        d1->day = v.getInt();
    }else if(feature == SymHour){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign time)");
        }
        SpTime* t1 = time.asTime();
        t1->hour = v.getInt();
    }else if(feature == SymMinute){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign time)");
        }
        SpTime* t1 = time.asTime();
        t1->minute = v.getInt();
    }else if(feature == SymSecond){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign time)");
        }
        SpTime* t1 = time.asTime();
        t1->second = v.getInt();
    }else{
        throw SpException("no such a feature(assign datetime)");
    }
}

// primitives

SpValue& SpDateTime::prim_now()
{
    SpInt y, m, d, h, min, s;
    time_t t;
    struct tm* area;

    t = ::time(NULL);
    area = localtime(&t);
    y = area->tm_year + 1900;
    m = area->tm_mon+1;
    d = area->tm_mday;
    h = area->tm_hour;
    min = area->tm_min;
    s = area->tm_sec;

    //    static SpValue result;
    //    result.setNewObject(new SpDateTime(y, m, d, h, min, s));
    //    return result;
    return SpObjectResult(new SpDateTime(y, m, d, h, min, s));
}

SpValue& SpDateTime::prim_new(SpValue& date, SpValue& time)
{
    if(!date.isDate()){
        throw SpException("not date datetime::new");
    }
    if(!time.isTime()){
        throw SpException("not time datetime::new");
    }
    SpDate* d = date.asDate();
    SpTime* t = time.asTime();
    /*
    static SpValue result;
    result.setNewObject(new SpDateTime(d->year,
                                       d->month,
                                       d->day,
                                       t->hour,
                                       t->minute,
                                       t->second));
    return result;
    */
    return SpObjectResult(new SpDateTime(d->year,
					 d->month,
					 d->day,
					 t->hour,
					 t->minute,
					 t->second));
}

SpValue& SpDateTime::prim_getYear(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpDate* p = dt->date.asDate();
    //    static SpValue result;
    //    result.setInt(p->year);
    //    return result;
    return SpIntResult(p->year);
}

SpValue& SpDateTime::prim_getMonth(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpDate* p = dt->date.asDate();
    //    static SpValue result;
    //    result.setInt(p->month);
    //    return result;
    return SpIntResult(p->month);
}

SpValue& SpDateTime::prim_getDay(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpDate* p = dt->date.asDate();
    //    static SpValue result;
    //    result.setInt(p->day);
    //    return result;
    return SpIntResult(p->day);
}

SpValue& SpDateTime::prim_getHour(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpTime* p = dt->time.asTime();
    //    static SpValue result;
    //    result.setInt(p->hour);
    //    return result;
    return SpIntResult(p->hour);
}

SpValue& SpDateTime::prim_getMinute(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpTime* p = dt->time.asTime();
    //    static SpValue result;
    //    result.setInt(p->minute);
    //    return result;
    return SpIntResult(p->minute);
}

SpValue& SpDateTime::prim_getSecond(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpTime* p = dt->time.asTime();
    //    static SpValue result;
    //    result.setInt(p->second);
    //    return result;
    return SpIntResult(p->second);
}

SpValue& SpDateTime::prim_getDate(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpDate* p = dt->date.asDate();
    //    static SpValue result;
    //    result.setObject(p);
    //    return result;
    return SpObjectResult(p);
}

SpValue& SpDateTime::prim_getTime(SpValue& self)
{
    SpDateTime* dt = self.asDateTime();
    SpTime* p = dt->time.asTime();
    //    static SpValue result;
    //    result.setObject(p);
    //    return result;
    return SpObjectResult(p);
}

// Message Handler
SpValue& SpDateTime::onMessage(SpValue& rec, SpValue& msg)
{
    return DateTimeMsgHandler(rec, msg);
}

// init
void SpDateTime::init()
{
    SpValue SymDateTime(new SpSymbol("datetime"));
    SpNameSpace* pDateTimeNS = new SpNameSpace;
    SpValue DateTimeNS(pDateTimeNS);
    PMainNameSpace->internConst(SymDateTime, DateTimeNS);

    // for Class
    SpValue SymNow(new SpSymbol("now"));
    SpValue PrimNow(new SpPrim0(prim_now));
    pDateTimeNS->internPrimProperty(SymNow, NilObject, PrimNow, NilObject);

    SpValue SymNew(new SpSymbol("new"));
    SpValue PrimNew(new SpPrim2(prim_new));
    pDateTimeNS->internConst(SymNew, PrimNew);

    // for Object
    SpValue GetYear(new SpPrim1(prim_getYear));
    DateTimeMsgHandler.append(SymYear, GetYear);

    SpValue GetMonth(new SpPrim1(prim_getMonth));
    DateTimeMsgHandler.append(SymMonth, GetMonth);

    SpValue GetDay(new SpPrim1(prim_getDay));
    DateTimeMsgHandler.append(SymDay, GetDay);

    SpValue GetHour(new SpPrim1(prim_getHour));
    DateTimeMsgHandler.append(SymHour, GetHour);

    SpValue GetMinute(new SpPrim1(prim_getMinute));
    DateTimeMsgHandler.append(SymMinute, GetMinute);

    SpValue GetSecond(new SpPrim1(prim_getSecond));
    DateTimeMsgHandler.append(SymSecond, GetSecond);

    SpValue GetDate(new SpPrim1(prim_getDate));
    DateTimeMsgHandler.append(SymDate, GetDate);

    SpValue GetTime(new SpPrim1(prim_getTime));
    DateTimeMsgHandler.append(SymTime, GetTime);
}

