/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Date.cpp,v 1.16 2004/07/04 12:32:36 randy Exp $
 */

#include <time.h>
#include "soopy.h"

static bool isLeapYear(SpInt year) // [NȂΐ^
{
    if((year % 100) == 0){
        if((year % 400) == 0){
            return true;
        }
    }else if((year % 4) == 0){
        return true;
    }
    return false;
}

void SpDate::regular()
{
    // month
    if(month <= 0){
        while(month <= 0){
            month += 12;
            year--;
        }
    }else if(month > 12){
        while(month > 12){
            month -= 12;
            year++;
        }
    }

    // day
    if(day <= 0){
        while(day <= 0){
            month--;
            if(month == 0){
                month = 12;
                year--;
            }
            switch(month){
              case 1:
              case 3:
              case 5:
              case 7:
              case 8:
              case 10:
              case 12:
                day = day + 31;
                break;
              case 4:
              case 6:
              case 9:
              case 11:
                day = day + 30;
                break;
              case 2:
                if(isLeapYear(year)){
                    day = day + 29;
                }else{
                    day = day + 28;
                }
                break;
              default:
                goto day_end;
            }
        }
    }else{
        while(true){
            switch(month){
              case 1:
              case 3:
              case 5:
              case 7:
              case 8:
              case 10:
              case 12:
                if(day > 31){
                    day = day - 31;
                    month++;
                    if(month == 13){
                        month = 1;
                    }
                }else{
                    goto day_end;
                }
                break;
              case 4:
              case 6:
              case 9:
              case 11:
                if(day > 30){
                    day = day - 30;
                    month++;
                    if(month == 13){
                        month = 1;
                    }
                }else{
                    goto day_end;
                }
                break;
              case 2:
                if(isLeapYear(year)){
                    if(day > 29){
                        day = day - 29;
                        month++;
                        if(month == 13){
                            month = 1;
                        }
                    }else{
                        goto day_end;
                    }
                }else{
                    if(day > 28){
                        day = day - 28;
                        month++;
                        if(month == 13){
                            month = 1;
                        }
                    }else{
                        goto day_end;
                    }
                }
                break;
              default:
                goto day_end;
            }
        }
    }
day_end:
    return;
}

SpValue& SpDate::plus(SpValue& e1, SpValue& e2)
{
    SpDate* d1 = e1.asDate();
    SpDate* date;
    if(e2.isInt()){
        SpInt i = e2.getInt();
        date = new SpDate(d1->year,
                          d1->month,
                          d1->day + i);
/*
    }else if(e2.isDate()){
        SpDate* d2 = e2.asDate();
        date = new SpDate(d1->year  + d2->year,
                          d1->month + d2->month,
                          d1->day   + d2->day);
*/
    }else{
        throw SpException("not int date::operator+");
    }
    date->regular();
    return SpObjectResult(date);
}

SpValue& SpDate::minus(SpValue& e1, SpValue& e2)
{
    SpDate* d1 = e1.asDate();
    SpDate* date;
    if(e2.isInt()){
        SpInt i = e2.getInt();
        date = new SpDate(d1->year,
                          d1->month,
                          d1->day - i);
/*
    }else if(e2.isDate()){
        SpDate* d2 = e2.asDate();
        SpDate* date = new SpDate(d1->year  - d2->year,
                                  d1->month - d2->month,
                                  d1->day   - d2->day);
*/
    }else{
        throw SpException("not int date::operator-");
    }
    date->regular();
    return SpObjectResult(date);
}

SpValue& SpDate::eq(SpValue& e1, SpValue& e2)
{
    if(!e2.isDate()){
        return SpBoolResult(false);
    }
    SpDate* t1 = e1.asDate();
    SpDate* t2 = e2.asDate();
    return SpBoolResult((t1->year == t2->year) && (t1->month == t2->month) && (t1->day == t2->day));
}

SpValue& SpDate::ne(SpValue& e1, SpValue& e2)
{
    if(!e2.isDate()){
        return SpBoolResult(true);
    }
    SpDate* t1 = e1.asDate();
    SpDate* t2 = e2.asDate();
    return SpBoolResult((t1->year != t2->year) || (t1->month != t2->month) || (t1->day != t2->day));
}

SpValue& SpDate::gt(SpValue& e1, SpValue& e2)
{
    if(!e2.isDate()){
        throw SpException("unmatch type (Date >)");
    }
    SpDate* t1 = e1.asDate();
    SpDate* t2 = e2.asDate();
    if(t1->year > t2->year){
        return SpBoolResult(true);
    }else if(t1->year == t2->year){
        if(t1->month > t2->month){
            return SpBoolResult(true);
        }else if(t1->month == t2->month){
            return SpBoolResult(t1->day > t2->day);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpDate::ge(SpValue& e1, SpValue& e2)
{
    if(!e2.isDate()){
        throw SpException("unmatch type (>=)");
    }
    SpDate* t1 = e1.asDate();
    SpDate* t2 = e2.asDate();
    if(t1->year > t2->year){
        return SpBoolResult(true);
    }else if(t1->year == t2->year){
        if(t1->month > t2->month){
            return SpBoolResult(true);
        }else if(t1->month == t2->month){
            return SpBoolResult(t1->day >= t2->day);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpDate::lt(SpValue& e1, SpValue& e2)
{
    if(!e2.isDate()){
        throw SpException("unmatch type (<)");
    }
    SpDate* t1 = e1.asDate();
    SpDate* t2 = e2.asDate();
    if(t1->year < t2->year){
        return SpBoolResult(true);
    }else if(t1->year == t2->year){
        if(t1->month < t2->month){
            return SpBoolResult(true);
        }else if(t1->month == t2->month){
            return SpBoolResult(t1->day < t2->day);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpDate::le(SpValue& e1, SpValue& e2)
{
    if(!e2.isDate()){
        throw SpException("unmatch type (<=)");
    }
    SpDate* t1 = e1.asDate();
    SpDate* t2 = e2.asDate();
    if(t1->year < t2->year){
        return SpBoolResult(true);
    }else if(t1->year == t2->year){
        if(t1->month < t2->month){
            return SpBoolResult(true);
        }else if(t1->month == t2->month){
            return SpBoolResult(t1->day <= t2->day);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpDate::toString()
{
    char buf[10];
    SpString* str = new SpString;
    sprintf(buf, "%d", year);
    *str += buf;
    sprintf(buf, "-%d", month);
    *str += buf;
    sprintf(buf, "-%d", day);
    *str += buf;
    //    static SpValue val;
    //    val.setNewObject(str);
    //    return val;
    return SpObjectResult(str);
}

void SpDate::assign(SpValue& feature, SpValue& value)
{
    SpValue v;

    if(feature == SymYear){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign date)");
        }
        year = v.getInt();
    }else if(feature == SymMonth){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign date)");
        }
        month = v.getInt();
    }else if(feature == SymDay){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign date)");
        }
        day = v.getInt();
    }else{
        throw SpException("no such a feature(assign date)");
    }
}

// primitives
SpValue& SpDate::prim_today()
{
    SpInt y, m, d;
    time_t t;
    struct tm* area;

    t = time(NULL);
    area = localtime(&t);
    y = area->tm_year + 1900;
    m = area->tm_mon+1;
    d = area->tm_mday;

    //    static SpValue result;
    //    result.setNewObject(new SpDate(y, m, d));
    //    return result;
    return SpObjectResult(new SpDate(y, m, d));
}

SpValue& SpDate::prim_new(SpValue& v1, SpValue& v2, SpValue& v3)
{
    SpInt y, m, d;

    if(!v1.isInt()){
        throw SpException("not int (Date.new)");
    }
    if(!v2.isInt()){
        throw SpException("not int (Date.new)");
    }
    if(!v3.isInt()){
        throw SpException("not int (Date.new)");
    }
    y = v1.getInt();
    m = v2.getInt();
    d = v3.getInt();

    //    static SpValue result;
    //    result.setNewObject(new SpDate(y, m, d));
    //    return result;
    return SpObjectResult(new SpDate(y, m, d));
}

SpValue& SpDate::prim_fromString(SpValue& date_str)
{
    SpInt y, m, d;
    SpValue temp;
    SpString* str = date_str.asString();

    SpValue v = str->split(MakeSpChar(CodeJIS, '-'));
    SpCons* list = (SpCons*)v.asList();
    if(list->length() != 3){
        throw SpException("illegal date format");
    }

    //y = int_fromString(list->value().asString());
    temp = list->value();
    y = int_fromString(temp.asString());
    temp = list->nextList();
    list = (SpCons*)temp.asList();
    //m = int_fromString(list->value().asString());
    temp = list->value();
    m = int_fromString(temp.asString());
    temp = list->nextList();
    list = (SpCons*)temp.asList();
    //d = int_fromString(list->value().asString());
    temp = list->value();
    d = int_fromString(temp.asString());

    //    static SpValue result;
    //    result.setNewObject(new SpDate(y, m, d));
    //    return result;
    return SpObjectResult(new SpDate(y, m, d));
}

SpValue& SpDate::prim_succ(SpValue& self)
{
    SpInt y, m, d;
    SpDate* date = self.asDate();

    y = date->year;
    m = date->month;
    d = date->day;
    SpDate* date2 = new SpDate(y, m, d+1);
    date2->regular();

    //    static SpValue result;
    //    result.setNewObject(date2);
    //    return result;
    return SpObjectResult(date2);
}

SpValue& SpDate::prim_pred(SpValue& self)
{
    SpInt y, m, d;
    SpDate* date = self.asDate();

    y = date->year;
    m = date->month;
    d = date->day;
    SpDate* date2 = new SpDate(y, m, d-1);
    date2->regular();

    //    static SpValue result;
    //    result.setNewObject(date2);
    //    return result;
    return SpObjectResult(date2);
}

SpValue& SpDate::prim_getYear(SpValue& self)
{
    SpDate* p = self.asDate();
    //    static SpValue result;
    //    result.setInt(p->year);
    //    return result;
    return SpIntResult(p->year);
}

SpValue& SpDate::prim_getMonth(SpValue& self)
{
    SpDate* p = self.asDate();
    //    static SpValue result;
    //    result.setInt(p->month);
    //    return result;
    return SpIntResult(p->month);
}

SpValue& SpDate::prim_getDay(SpValue& self)
{
    SpDate* p = self.asDate();
    //    static SpValue result;
    //    result.setInt(p->day);
    //    return result;
    return SpIntResult(p->day);
}

// Message Handler
SpValue& SpDate::onMessage(SpValue& rec, SpValue& msg)
{
    return DateMsgHandler(rec, msg);
}

// init
void SpDate::init()
{
    SpNameSpace* pDateNS = new SpNameSpace;
    SpValue DateNS(pDateNS);
    PMainNameSpace->internConst(SymDate, DateNS);

    // for Class
    SpValue SymToday(new SpSymbol("today"));
    SpValue PrimToday(new SpPrim0(prim_today));
    pDateNS->internPrimProperty(SymToday, NilObject, PrimToday, NilObject);

    SpValue SymNew(new SpSymbol("new"));
    SpValue PrimNew(new SpPrim3(prim_new));
    pDateNS->internConst(SymNew, PrimNew);

    SpValue SymFromString(new SpSymbol("fromstring"));
    SpValue PrimFromString(new SpPrim1(prim_fromString));
    pDateNS->internConst(SymFromString, PrimFromString);

    // for Object
    SpValue GetYear(new SpPrim1(prim_getYear));
    DateMsgHandler.append(SymYear, GetYear);

    SpValue GetMonth(new SpPrim1(prim_getMonth));
    DateMsgHandler.append(SymMonth, GetMonth);

    SpValue GetDay(new SpPrim1(prim_getDay));
    DateMsgHandler.append(SymDay, GetDay);

    SpValue PrimSucc(new SpPrim1(prim_succ));
    DateMsgHandler.append(SymSucc, PrimSucc);

    SpValue PrimPred(new SpPrim1(prim_pred));
    DateMsgHandler.append(SymPred, PrimPred);
}


