/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Database.cpp,v 1.2 2004/03/21 05:48:06 randy Exp $
 */

#ifdef USE_DATABASE

#include "soopy.h"

SpDatabase::SpDatabase(char* name)
{
    database = new DB(name);
}

SpDatabase::~SpDatabase()
{
    // IɃN[YȂĂAsoopyI
    // JĂf[^x[Xׂ͂ăN[YB
    database->close();
}

void SpDatabase::open()
{
    database->open();
}

void SpDatabase::close()
{
    database->close();
}

void SpDatabase::setRoot(SpValue& name, SpValue& obj)
{
    database->setRoot(name, obj);
}

SpValue& SpDatabase::getRoot(SpValue& name)
{
    return database->getRoot(name);
}

// Message Handler
SpValue& SpDatabase::onMessage(SpValue& rec, SpValue& msg)
{
    try{
        return getRoot(msg);
    }catch(SpException& e){
        try{
            return DatabaseMsgHandler(rec, msg);
        }catch(SpNoMethodException& e){
            return NilObject;
        }
    }
}

SpValue& SpDatabase::toString()
{
    SpString* str = new SpString("<database>");
    //    static SpValue val;
    //    val.setNewObject(str);
    //    return val;
    return SpObjectResult(str);
}

SpValue& SpDatabase::prim_open(SpValue& filename)
{
    if(!filename.isString()){
        throw SpException("not string. (database open)");
    }
    SpString* name = filename.asString();
    SpDatabase* db = new SpDatabase((char*)name->toCStringWithEncoder());
    db->open();

    //    static SpValue result;
    //    result.setNewObject(db);
    //    return result;
    return SpObjectResult(db);
}

SpValue& SpDatabase::prim_close(SpValue& self)
{
    SpDatabase* db = self.asDatabase();
    db->close();
    return TrueObject;
}


// init
void SpDatabase::init()
{
    SpNameSpace* pDBNS = new SpNameSpace;
    SpValue DBNS(pDBNS);
    PMainNameSpace->internConst(SymDatabase, DBNS);

    // for Class
    SpValue PrimOpen(new SpPrim1(prim_open));
    pDBNS->internFunc(SymOpen, PrimOpen);

    // for Object
    SpValue PrimClose(new SpPrim1(prim_close));
    DatabaseMsgHandler.append(SymClose, PrimClose);
/*
    SpValue PrimSave(new SpPrim1(prim_save));
    SpValue SymSave(new SpSymbol("save"));
    DatabaseMsgHandler.append(SymSave, PrimSave);

    SpValue PrimSetRoot(new SpPrim3(prim_setRoot));
    SpValue SymSetRoot(new SpSymbol("setroot"));
    DatabaseMsgHandler.append(SymSetRoot, PrimSetRoot);

    SpValue PrimGetRoot(new SpPrim2(prim_getRoot));
    SpValue SymGetRoot(new SpSymbol("getroot"));
    DatabaseMsgHandler.append(SymGetRoot, PrimGetRoot);
*/


/*
    SpValue PrimRename(new SpPrim2(rename));
    DatabaseMsgHandler.append(SymRename, PrimRename);

    SpValue SymEval(new SpSymbol("eval"));
    SpValue PrimEval(new SpPrim1(make_func));
    DatabaseMsgHandler.append(SymEval, PrimEval);

    PrimAppend.setNewObject(new SpPrim3(prim_append));
    DatabaseMsgHandler.append(SymAppend, PrimAppend);

    SpValue PrimKeys(new SpPrim1(prim_keys));
    DatabaseMsgHandler.append(SymKeys, PrimKeys);

    SpValue PrimDelete(new SpPrim2(prim_delete));
    DatabaseMsgHandler.append(SymDelete, PrimDelete);

    SpValue SymLookup(new SpSymbol("lookup"));
    SpValue PrimLookup(new SpPrim2(prim_lookup));
    DatabaseMsgHandler.append(SymLookup, PrimLookup);
*/
}


#endif /* USE_DATABASE */
