/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Assign.cpp,v 1.24 2004/03/25 13:25:48 randy Exp $
 */


#include "soopy.h"

/*
 * class SpAssign
 */

SpAssign::~SpAssign()
{
#ifdef TEST
    *spout << ":destroy Assign:" << "\n";
#endif
}

SpValue& SpAssign::eval()
{
    SpValue v0 = getCurrentNS();
    SpNameSpace* ns = dynamic_cast<SpNameSpace*>(v0.getObject());
    //    static SpValue v;
    SpValue v, temp;

    v = val.eval();
    SpValue p(new NSVar(place));
    ns->setValue(p, v, ns);
    //    return v;
    return SpValueResult(v);
}

SpValue& SpAssign::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    *str += place.toString();
    *str += " = ";
    *str += val.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpAssign::operator==(SpObject& obj)
{
    SpAssign* ptr = dynamic_cast<SpAssign*>(&obj);
    if(ptr != NULL){
        return (place == ptr->place) &&
                (val == ptr->val);
    }
    return false;
}

bool SpAssign::operator<(SpObject& obj)
{
    SpAssign* ptr = dynamic_cast<SpAssign*>(&obj);
    if(ptr != NULL){
        if(place != ptr->place){
            return place < ptr->place;
        }
        return val < ptr->val;
    }
    return SpObject::operator<(obj);
}


/*
 * class SpAssignS
 */

SpAssignS::~SpAssignS()
{
#ifdef TEST
    *spout << ":destroy AssignS:" << "\n";
#endif
}

SpValue& SpAssignS::eval()
{
    SpValue v0 = getCurrentNS();
    SpNameSpace* ns = dynamic_cast<SpNameSpace*>(v0.getObject());
    //    static SpValue values;
    //    static SpValue v;
    SpValue values;
    SpValue v;

    values = val.eval();
    if(!values.isObject()){
        throw SpException("not tuple in let");
    }
    SpTuple* tuple = dynamic_cast<SpTuple*>(values.getObject());
    if(tuple == NULL){
        throw SpException("not tuple in let");
    }
    if(tuple->length() != (SpInt)places.size()){
        throw SpException("arg length mismatch in let");
    }
    SpValueVector::iterator dist = places.begin();
    SpValueVector::iterator src = tuple->begin();
    for(; dist != places.end(); src++, dist++){
        SpValue p;
        p.setNewObject(new NSVar(*dist));
        v = *src;
        ns->setValue(p, v, ns);
    }
    //    return v;
    return SpValueResult(v);
}

SpValue& SpAssignS::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    *str = "AssignS(";
    SpValueVector::iterator it = places.begin();
    *str += it->toString();
    it++;
    for(; it != places.end(); it++){
        *str += ",";
        *str += it->toString();
    }
    *str += " <= ";
    *str += val.toString();
    *str += ")";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpAssignS::operator==(SpObject& obj)
{
    SpAssignS* ptr = dynamic_cast<SpAssignS*>(&obj);
    if(ptr != NULL){
        if(places.size() != ptr->places.size()){
            return false;
        }
        SpValueVector::iterator it1, it2;
        it1 = places.begin();
        it2 = ptr->places.begin();
        for(; it1 != places.end(); it1++, it2++){
            if(*it1 != *it2){
                return false;
            }
        }
        return true;
    }
    return false;
}

bool SpAssignS::operator<(SpObject& obj)
{
    SpAssignS* ptr = dynamic_cast<SpAssignS*>(&obj);
    if(ptr != NULL){
        if(places.size() != ptr->places.size()){
            return places.size() < ptr->places.size();
        }
        SpValueVector::iterator it1, it2;
        it1 = places.begin();
        it2 = ptr->places.begin();
        for(; it1 != places.end(); it1++, it2++){
            if(*it1 != *it2){
                return *it1 < *it2;
            }
        }
        return val < ptr->val;
    }
    return SpObject::operator<(obj);
}

/*
 * class SpAssignSM
 */

SpAssignSM::~SpAssignSM()
{
#ifdef TEST
    *spout << ":destroy AssignSM:" << "\n";
#endif
}

SpValue& SpAssignSM::eval()
{
    //    static SpValue v;
    SpValue v;

    SpSendMsg* ptr = dynamic_cast<SpSendMsg*>(place.getObject());
    if(ptr == NULL){ throw SpSystemError(__FILE__, __LINE__); }
    SpValue nspace = ptr->receiver.eval();
    SpValue feature = ptr->message;
    if(nspace.isByteArray()){
        SpByteArray* ary = dynamic_cast<SpByteArray*>(nspace.getObject());
        v = val.eval();
        CheckType(SymInt, v);
        SpValue index = feature.eval();
        (*ary)[index] = (unsigned char)v.getInt();
    }else if(nspace.isArray()){
        SpArray* ary = dynamic_cast<SpArray*>(nspace.getObject());
        v = val.eval();
        CheckType(ary->getFeatureType(), v);
        SpValue index = feature.eval();
        ary->set(index, v);
    }else if(nspace.isNameSpace()){
        SpNameSpace* ns = dynamic_cast<SpNameSpace*>(nspace.getObject());
        SpValue curNS = getCurrentNS();
        SpNameSpace* cur_ns = curNS.asNameSpace();
        SpValue p2(new NSVar(feature));
        v = val.eval();
        ns->setValue(p2, v, cur_ns);
#ifdef USE_DATABASE
    }else if(nspace.isDatabase()){
        SpDatabase* db = dynamic_cast<SpDatabase*>(nspace.getObject());
        v = val.eval();
        db->setRoot(feature, v);
#endif
    }else if(nspace.isDate()){
        SpDate* date = dynamic_cast<SpDate*>(nspace.getObject());
        v = val.eval();
        date->assign(feature, v);
    }else if(nspace.isTime()){
        SpTime* time = dynamic_cast<SpTime*>(nspace.getObject());
        v = val.eval();
        time->assign(feature, v);
    }else if(nspace.isDateTime()){
        SpDateTime* dt = dynamic_cast<SpDateTime*>(nspace.getObject());
        v = val.eval();
        dt->assign(feature, v);
    }else{
        throw SpException("not namespace (assign)");
    }
    //    return v;
    return SpValueResult(v);
}

SpValue& SpAssignSM::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    *str = "Assign(";
    *str += place.toString();
    *str += " <= ";
    *str += val.toString();
    *str += ")";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpAssignSM::operator==(SpObject& obj)
{
    SpAssignSM* ptr = dynamic_cast<SpAssignSM*>(&obj);
    if(ptr != NULL){
        return (place == ptr->place) &&
                (val == ptr->val);
    }
    return false;
}

bool SpAssignSM::operator<(SpObject& obj)
{
    SpAssignSM* ptr = dynamic_cast<SpAssignSM*>(&obj);
    if(ptr != NULL){
        if(place != ptr->place){
            return place < ptr->place;
        }
        return val < ptr->val;
    }
    return SpObject::operator<(obj);
}

/*
 * class SpAssignList
 */

SpAssignList::~SpAssignList()
{
#ifdef TEST
    *spout << ":destroy AssignList:" << "\n";
#endif
}

SpValue& SpAssignList::eval()
{
    SpValue v0 = getCurrentNS();
    SpNameSpace* ns = dynamic_cast<SpNameSpace*>(v0.getObject());
    //    static SpValue values;
    //    static SpValue v;
    SpValue values;
    SpValue v;

    values = val.eval();
    if(!values.isObject()){
        throw SpException("not list in let");
    }
    SpList* list = dynamic_cast<SpList*>(values.getObject());
    if(list == NULL){
        throw SpException("not list in let");
    }

    SpNameSpace dammy;
    SpValueVector::iterator dist = places.begin();
    SpList* src = list;
    for(; dist != places.end(); src = src->next(), dist++){
        if(src == NULL){
            throw SpException("arg length mismatch in let list");
        }
        v = src->value();
        dammy.internVar(*dist, v);
    }
    if(src != NULL){
        throw SpException("arg length mismatch in let list");
    }
    // copy dammy to current NameSpace
    *ns += dammy;
    //    return v;
    return SpValueResult(v);
}

SpValue& SpAssignList::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    *str = "AssignList(";
    SpValueVector::iterator it = places.begin();
    *str += it->toString();
    it++;
    for(; it != places.end(); it++){
        *str += ",";
        *str += it->toString();
    }
    *str += " <= ";
    *str += val.toString();
    *str += ")";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpAssignList::operator==(SpObject& obj)
{
    SpAssignList* ptr = dynamic_cast<SpAssignList*>(&obj);
    if(ptr != NULL){
        if(places.size() != ptr->places.size()){
            return false;
        }
        SpValueVector::iterator it1, it2;
        it1 = places.begin();
        it2 = ptr->places.begin();
        for(; it1 != places.end(); it1++, it2++){
            if(*it1 != *it2){
                return false;
            }
        }
        return true;
    }
    return false;
}

bool SpAssignList::operator<(SpObject& obj)
{
    SpAssignList* ptr = dynamic_cast<SpAssignList*>(&obj);
    if(ptr != NULL){
        if(places.size() != ptr->places.size()){
            return places.size() < ptr->places.size();
        }
        SpValueVector::iterator it1, it2;
        it1 = places.begin();
        it2 = ptr->places.begin();
        for(; it1 != places.end(); it1++, it2++){
            if(*it1 != *it2){
                return *it1 < *it2;
            }
        }
        return val < ptr->val;
    }
    return SpObject::operator<(obj);
}

/*
 * class SpAssignHT (Head & Tail)
 */

SpAssignHT::~SpAssignHT()
{
#ifdef TEST
    *spout << ":destroy AssignHT:" << "\n";
#endif
}

SpValue& SpAssignHT::eval()
{
    SpValue v0 = getCurrentNS();
    SpNameSpace* ns = dynamic_cast<SpNameSpace*>(v0.getObject());
    SpValue values = val.eval();
    if(!values.isList()){
        throw SpException("not list in let");
    }
    SpList* list = values.asList();

    //    ns->internVar(head, list->value());
    SpValue temp;
    temp = list->value();
    ns->internVar(head, temp);
    //    static SpValue v;
    SpValue v;
    v = list->nextList();
    v = v.eval();
    ns->internVar(tail, v);

    //    return v;
    return SpValueResult(v);
}

SpValue& SpAssignHT::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    *str = "let ";
    *str += head.toString();
    *str += "::";
    *str += tail.toString();
    *str += " = ";
    *str += val.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

bool SpAssignHT::operator==(SpObject& obj)
{
    SpAssignHT* ptr = dynamic_cast<SpAssignHT*>(&obj);
    if(ptr != NULL){
        if(head != ptr->head){
            return false;
        }
        if(tail != ptr->tail){
            return false;
        }
        return val == ptr->val;
    }
    return false;
}

bool SpAssignHT::operator<(SpObject& obj)
{
    SpAssignHT* ptr = dynamic_cast<SpAssignHT*>(&obj);
    if(ptr != NULL){
        if(head != ptr->head){
            return head < ptr->head;
        }
        if(tail != ptr->tail){
            return tail < ptr->tail;
        }
        return val < ptr->val;
    }
    return SpObject::operator<(obj);
}

