﻿using System;
using System.Windows.Forms;

namespace Somali.Base
{
    /// <summary>
    /// WindowStateChanged イベントのデータを提供します。
    /// </summary>
    public class WindowStateChangedEventArgs : EventArgs 
    {
        public WindowStateChangedEventArgs( FormWindowState windowState )
        {
            this._WindowState = windowState;
        }

        private FormWindowState _WindowState;
        /// <summary>
        /// 新しい ウィンドウ状態を取得します。
        /// </summary>
        public FormWindowState WindowState
        {
            get { return _WindowState; }
        }
    }
}
