﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace Somali.EnvControl
{
    class ResourceSecretary : Somali.Base.BaseSecretary
    {
        private string _explrDirPath = String.Empty;
        private TreeNode _explrTree = null;

        public ResourceSecretary()
        {
        }

        public TreeNode GetExplorerTree( string dirPath )
        {

            //try
            //{
            //    Directory.GetFiles( dirPath, "*", SearchOption.AllDirectories );
            //}
            //catch ( UnauthorizedAccessException e )
            //{
            //    MessageBox.Show( "参照権限がありません。\n" + e.Message );
            //    return null;
            //}

            DirectoryInfo dirInfo = new DirectoryInfo( dirPath );
            TreeNode root = new TreeNode( dirInfo.Name );
            root.ImageIndex = (int)ExplorerForm.NodeIcon.FolderClose;
            root.SelectedImageIndex = (int)ExplorerForm.NodeIcon.FolderOpen;
            root.Nodes.Add( "dummy" );

            this._explrDirPath = dirInfo.Parent != null ? dirInfo.Parent.FullName : String.Empty;
            this._explrTree = root;
            return root;
        }

        public void ExpandExplorerNode( TreeNode treeNode )
        {
            if ( treeNode == null )
            {
                throw new ArgumentNullException();
            }

            if ( this._explrTree.TreeView.Equals( treeNode.TreeView ) )
            {
                ExpandNode( this._explrDirPath, treeNode );
            }
            else
            {
                throw new ArgumentException();
            }
        }

        private void ExpandNode( string dirPath, TreeNode treeNode )
        {
            treeNode.Nodes.Clear();

            string path = dirPath + (dirPath.Equals( String.Empty ) ? String.Empty : @"\") + treeNode.FullPath;
            DirectoryInfo dirInfo = new DirectoryInfo( path );
            if ( dirInfo.Exists )
            {
                try
                {
                    DirectoryInfo[] subDir = dirInfo.GetDirectories();
                    foreach ( DirectoryInfo di in subDir )
                    {
                        if ( (di.Attributes & FileAttributes.Hidden) != FileAttributes.Hidden )
                        {
                            TreeNode node = treeNode.Nodes.Add( di.Name );
                            node.ImageIndex = (int)ExplorerForm.NodeIcon.FolderClose;
                            node.SelectedImageIndex = (int)ExplorerForm.NodeIcon.FolderOpen;

                            node.Nodes.Add( "dummy" );
                        }
                    }

                    FileInfo[] files = dirInfo.GetFiles();
                    foreach ( FileInfo fi in files )
                    {
                        if ( (fi.Attributes & FileAttributes.Hidden) != FileAttributes.Hidden )
                        {
                            TreeNode node = treeNode.Nodes.Add( fi.Name );
                            // TODO:拡張子によるアイコンの変更
                            node.ImageIndex = node.SelectedImageIndex = (int)ExplorerForm.NodeIcon.FilePlain;
                        }
                    }
                }
                catch ( UnauthorizedAccessException e )
                {
                    MessageBox.Show( "参照権限がありません。\n" + e.Message );
                }
            }
        }

    }
}
