package demo.soot;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import soot.Body;
import soot.BodyTransformer;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Transform;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.pdg.ConditionalPDGNode;
import soot.toolkits.graph.pdg.HashMutablePDG;
import soot.toolkits.graph.pdg.PDGNode;
import soot.toolkits.graph.pdg.ProgramDependenceGraph;
import demo.util.DemoUtil;
import demo.util.MemoryInfo;

public class ControlDependencePerformance {

	public static void main(String[] args) {
		List<String> argsList = Arrays.asList(new String[]{
				"-cp",
				"bin" + File.pathSeparator + 
				"bin/demo/testdata" + File.pathSeparator + 
				DemoUtil.RT_PATH + File.pathSeparator +
				DemoUtil.JCE_PATH,
				"-whole-program",
				"-main-class",
				"demo.testdata.TestClass",//main-class
//				"-app",
//				"demo.testdata.TestClass",
//				"demo.testdata.TestClass",//argument classes
				"-p",
				"cg.cha",
				"apponly:true,verbose:true",
				"demo.testdata.TestClass"
//				"-keep-line-number"
		});
		
		PackManager.v().getPack("jap").add(new Transform("jap.myTransform", new BodyTransformer() {
			@Override
			protected void internalTransform(Body body, String phase, Map options) {
				try {
					UnitGraph graph = new ExceptionalUnitGraph(body);
					ProgramDependenceGraph pdg = new HashMutablePDG(graph);
					for (PDGNode node1: pdg.getNodes()) {
						// Extracts only control-dependence edges
						if (node1 instanceof ConditionalPDGNode) {
							for (PDGNode node2: pdg.getDependents(node1)) {
//								System.out.println(node1.toShortString() + " -> " + node2.toShortString());
							}
						}
					}
				} catch (RuntimeException e) {
					System.err.println(body.getMethod());
				}
			}
		}));
//		Options.v().set_verbose(true);
		PhaseOptions.v().setPhaseOption("jap.npc", "on");
		
		args = argsList.toArray(new String[0]);

		long start = System.currentTimeMillis();
		soot.Main.main(args);
		long end = System.currentTimeMillis();
		
		System.out.println((end - start) + " [ms]");
		System.out.println(MemoryInfo.getMemoryInfo());
	}

}
