package demo.soot;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.Transform;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import demo.util.DemoUtil;
import demo.util.MemoryInfo;

public class ClassHierarchyPerformance {

	public static void main(String[] args) {
//		List<String> argsList = new ArrayList<String>(Arrays.asList(args));
		List<String> argsList = Arrays.asList(new String[]{
				"-cp",
				"bin" + File.pathSeparator + 
				"bin/testers" + File.pathSeparator + 
				DemoUtil.RT_PATH + File.pathSeparator +
				DemoUtil.JCE_PATH,
				"-whole-program",
				"-main-class",
				"testers.CallGraphs",//main-class
//				"-app",
//				"testers.CallGraphs",
				"-p",
				"cg.cha",
				"apponly:true,verbose:true",
				"testers.CallGraphs",//argument classes
				"testers.A"			//
		});

		long start = System.currentTimeMillis();
		
		PackManager.v().getPack("wjtp").add(new Transform("wjtp.myTrans", new SceneTransformer() {
			@Override
			protected void internalTransform(String phaseName, Map options) {
				CallGraph cg = Scene.v().getCallGraph();
				for (Iterator<MethodOrMethodContext> callers = cg.sourceMethods(); callers.hasNext();) {
					MethodOrMethodContext caller = callers.next();
					for (Iterator<Edge> edges = cg.edgesOutOf(caller); edges.hasNext();) {
						Edge edge = edges.next();
//						System.out.println(edge.getSrc().method().toString() + " -> " + edge.getTgt().method().toString());
					}
				}
				
				long end = System.currentTimeMillis();
				
				System.out.println((end - start) + " [ms]");
				System.out.println(MemoryInfo.getMemoryInfo());
			}
		}));

		args = argsList.toArray(new String[0]);

		soot.Main.main(args);
	}

}
