package demo.soot;

import java.util.Iterator;
import java.util.Map;

import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootMethod;
import soot.Transform;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import demo.util.MemoryInfo;

public class ClassHierarchyPerformance {

	public static void main(String[] args) {
		PackManager.v().getPack("wjtp").add(new Transform("wjtp.myTrans", new SceneTransformer() {
			@Override
			protected void internalTransform(String phaseName, Map options) {
				CallGraph cg = Scene.v().getCallGraph();
				for (Iterator<MethodOrMethodContext> callers = cg.sourceMethods(); callers.hasNext();) {
					MethodOrMethodContext caller = callers.next();
					for (Iterator<Edge> edges = cg.edgesOutOf(caller); edges.hasNext();) {
						Edge edge = edges.next();
						SootMethod srcMethod = edge.getSrc().method();
						SootMethod tgtMethod = edge.getTgt().method();
//						System.out.println(srcMethod.toString() + " -> " + tgtMethod.toString());
					}
				}		
			}
		}));

		long start = System.currentTimeMillis();
		soot.Main.main(args);
		long end = System.currentTimeMillis();

		System.err.println((end - start) + " [ms]");
		System.err.println(MemoryInfo.getMemoryInfo());
	}

}
