/* $Id: PropFindModel.java 125 2011-03-09 09:49:51Z ohura $ */
package webdav.table;
//-*- mode:java; encoding:utf8n; coding:utf-8 -*-
// vim:set fileencoding=utf-8:
//http://terai.xrea.jp/Swing/ExplorerLikeTable.html
import java.awt.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.*;
import javax.swing.table.*;

import org.apache.webdav.lib.Lock;

import webdav.PropFindInfo;

public class PropFindModel extends DefaultTableModel {
    private static final ColumnContext[] columnArray = {
        new ColumnContext("No.",  Integer.class, false),
        new ColumnContext("Name", String.class,  false),
        new ColumnContext("Last Modified", String.class,  false),
        new ColumnContext("Size", String.class,  false),
        new ColumnContext("Lock", String.class,  false)
    };
    private Integer number = new Integer(0);
    public void addPropFindList(PropFindInfo t) {
    	
    	String dateStr ="";
    	try{
    		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    		dateStr = sdf.format(t.getLastmodified());
    	}catch(Exception e){}
    	
    	String size="";
    	if(!t.isDirectory()){
    		size = String.valueOf(t.getContentlength());
    	}
    	StringBuffer lockOwner = new StringBuffer();
    	ArrayList lockList = t.getLocks();
    	if(lockList.size() != 0){
    		for(int i=0;i<lockList.size();i++){
    			Lock lock = (Lock)lockList.get(i);
    			if(lockList.size() -1 != i){
    				lockOwner.append(lock.getOwner() + ",");
    			}else{
    				lockOwner.append(lock.getOwner());
    			}
    		}
    	}
        Object[] obj = {number, t.getDisplayname(), dateStr,size,lockOwner.toString()};
        super.addRow(obj);
        int temp = number.intValue();
        temp++;
        number = new Integer(temp);
    }
    public void clear(){
    	int count = this.getRowCount();
    	for(int i=0;i<count;i++){
    		this.removeRow(0);
    	}
    }
    public boolean isCellEditable(int row, int col) {
        return columnArray[col].isEditable;
    }
    public Class getColumnClass(int modelIndex) {
        return columnArray[modelIndex].columnClass;
    }
    public int getColumnCount() {
        return columnArray.length;
    }
    public String getColumnName(int modelIndex) {
        return columnArray[modelIndex].columnName;
    }
    private static class ColumnContext {
        public final String  columnName;
        public final Class   columnClass;
        public final boolean isEditable;
        public ColumnContext(String columnName, Class columnClass, boolean isEditable) {
            this.columnName = columnName;
            this.columnClass = columnClass;
            this.isEditable = isEditable;
        }
    }
}
