package smart_gs.util;

import java.awt.Image;

import smart_gs.image_search.logical.TextType;
import sml_editor.logical.LineDirection;

public class ImageAdjuster {

	public static Image adjust(Image queryImage, LineDirection lineDirection, double d) {
		
		double height = queryImage.getHeight(null);
		double width = queryImage.getWidth(null);
		if (lineDirection == LineDirection.HORIZONTAL && height>d) {
			double ratio2 = d /  height;
			width *= ratio2;
			height *= ratio2;
			return queryImage.getScaledInstance((int)width, (int)height, Image.SCALE_DEFAULT);
		} else if (lineDirection == LineDirection.VERTICAL && width>d) {
			double ratio2 = d /  width;
			width *= ratio2;
			height *= ratio2;
			return queryImage.getScaledInstance((int)width, (int)height, Image.SCALE_DEFAULT);
		} else {
			return queryImage;
		}
	}

}
