package smart_gs.image_search.normal.swingui;

/* $Id: SetScopePanel.java 344 2011-09-08 13:43:20Z shayashi $ */

import javax.swing.*;
import javax.swing.event.*;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.Hashtable;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.BoxLayout;

public class SetSearchOptionPanel extends JPanel implements ChangeListener{
	private static JRadioButton concurrentButton;
	private static JRadioButton sequentialButton;
	private static JSlider slider;
	private static float pos = 1.0f;
	
	public SetSearchOptionPanel(){
		setLayout(new BorderLayout());
		setBorder(new TitledBorder("Options"));

		concurrentButton = new JRadioButton("Concurrent");
		sequentialButton = new JRadioButton("Sequential");

		ButtonGroup group1 = new ButtonGroup();

		group1.add(concurrentButton);
		group1.add(sequentialButton);
		
		add(concurrentButton,BorderLayout.WEST);
		add(sequentialButton,BorderLayout.EAST);
		concurrentButton.setSelected(true);

		Hashtable<Integer, JComponent> table = new Hashtable<Integer, JComponent>();

	    table.put(new Integer(1), new JLabel("2M"));
	    table.put(new Integer(10), new JLabel("200M"));

	    slider = new JSlider(1, 10);
	    slider.setValue(10);
	    slider.setMajorTickSpacing(1);
	    slider.setPaintTicks(true);
	    slider.setLabelTable(table);
	    slider.setPaintLabels(true);
	    slider.addChangeListener(this);
	    
	    add(slider,BorderLayout.SOUTH);

	}

	public void stateChanged(ChangeEvent e) {
		pos = (float)(slider.getValue()) / 10.0f;
	}

	public static float getPos() {
		return pos;
	}
	
	public static boolean isConcurrent() {
		return concurrentButton.isSelected();
	}
}
