/* $Id: SelectedResultViewer.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import smart_gs.image_search.LineImageCropper;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.swingui.ButtonDialog;

@SuppressWarnings("serial")
public class SelectedResultViewer extends ButtonDialog{
	
	protected final int MARGIN_WIDTH = 100;

	protected Color grayColor;
	
	public SelectedResultViewer(GSQuery query){
		super(new JFrame(),"Selected Result");
		this.setModal(true);
		Color color = Color.GRAY.brighter();
		this.grayColor = new Color(color.getRed(),color.getGreen(),color.getBlue(),128);
		this.getContentPane().setLayout(new BorderLayout());
		JScrollPane scrollPane = new JScrollPane();
		JPanel mainPanel = new JPanel(new GridLayout(1,1));

		JPanel entryPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		entryPanel.add(this.createImagePanel(query));
		mainPanel.add(entryPanel);
	
		scrollPane.setViewportView(mainPanel);
		this.getContentPane().add(scrollPane,BorderLayout.CENTER);
		this.getContentPane().add(this.getButtonPanel(),BorderLayout.SOUTH);
		this.pack();
	}
	private JPanel createImagePanel(GSQuery query){
		JPanel imagePanel = new JPanel();
		LineImageCropper cropper = new LineImageCropper(query);
		BufferedImage image = cropper.crop();
		Rectangle rect = query.getRectangle();
		int x = cropper.getX();
		int y = cropper.getY();
		ExLabel label = new ExLabel(new ImageIcon(image));
		label.setRectangle(new Rectangle(rect.x-x,rect.y-y,rect.width,rect.height));
		imagePanel.add(label);
		ModifyMouseListener listener = new ModifyMouseListener(label,image,query,imagePanel,x,y);
		label.addMouseListener(listener);
		label.addMouseMotionListener(listener);
	
		return imagePanel;
	}
	
	private class ExLabel extends JLabel{
		
		private Rectangle rectangle;
		
		public ExLabel(Icon icon){
			super(icon);
		}
		public void setRectangle(Rectangle rectangle){
			this.rectangle = rectangle;
		}
		public void setRectangle(int beginX, int endX){
			int beginY = this.rectangle.y;
			int width = endX - beginX;
			this.rectangle = new Rectangle(beginX,beginY,width,this.rectangle.height);
		}
		@Override
		public void paint(Graphics g) {
			super.paint(g);
			if(this.rectangle == null){
				return ;
			}
			Color oldColor = g.getColor();
			g.setColor(grayColor);
			g.fillRect(rectangle.x,rectangle.y,rectangle.width,rectangle.height);
			g.setColor(oldColor);
		}
	}
	
	private class ModifyMouseListener implements MouseListener,MouseMotionListener{
		
		JPanel imagePanel;
		private GSQuery result;
		private Point start;
		private Point end;
		private ExLabel label;
		private int x;
		private int y;
		
		
		public ModifyMouseListener(ExLabel label,Image image,GSQuery result, JPanel imagePanel,int x,int y) {
			this.label = label;
			this.result = result;
			this.imagePanel = imagePanel;
			this.x = x;
			this.y = y;
			
		}
		public void mouseClicked(MouseEvent e) {
			
		}
		public void mouseEntered(MouseEvent e) {
			
		}
		public void mouseExited(MouseEvent e) {
			
		}
		public void mousePressed(MouseEvent e) {
			this.start = e.getPoint();
			
		}
		public void mouseReleased(MouseEvent e) {
			this.end = e.getPoint();

			Rectangle rectangle = new Rectangle(this.x+this.start.x,this.y+this.start.y,this.end.x-this.start.x,this.end.y-this.start.y);
			Rectangle rectangle2 = new Rectangle(this.start.x,this.start.y,this.end.x-this.start.x,this.end.y-this.start.y);
			result.setRectangle(rectangle);
			label.setRectangle(rectangle2);
			repaint();
		}
		public void mouseDragged(MouseEvent e) {
			this.end = e.getPoint();			
			Rectangle rectangle = new Rectangle(this.x+this.start.x,this.y+this.start.y,this.end.x-this.start.x,this.end.y-this.start.y);
			Rectangle rectangle2 = new Rectangle(this.start.x,this.start.y,this.end.x-this.start.x,this.end.y-this.start.y);

			result.setRectangle(rectangle);
			label.setRectangle(rectangle2);
	        repaint();
			
		}
		public void mouseMoved(MouseEvent e) {
			
		}
	}

	@Override
	public void cancel() {
		this.dispose();
	}

	@Override
	public void ok() {
		dispose();
	}
}
