/* $Id: ResultPanel.java 783 2013-10-22 13:07:54Z ohura $ */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.UsersNote;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;
import javax.swing.text.Highlighter;
import javax.swing.text.DefaultHighlighter.DefaultHighlightPainter;

import com.lightdev.app.shtm.SGSHTMLEditorTextPane;

import smart_gs.logical.GSResource;
import smart_gs.logical.IDAT;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.URIObject;
import smart_gs.logical.URISolver;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTabbedPane;
import sml_editor.swingui.GSHTMLEditorTextPane;
import smart_gs.smleditor.swingui.GSTextEditor;
import smart_gs.swingui.WorkspaceWindow;



@SuppressWarnings("serial")
public class ResultPanel extends JPanel{
	private JPanel resultPanel;
	private int length;
	private ResultPanel(TextToShow textToShow, String documentURI,int index){
		super();
		resultPanel = this;
		length = textToShow.getLength();
		this.setPreferredSize(new Dimension(200, 50));
		this.setLayout(new BorderLayout());
		this.setBorder(new TitledBorder(documentURI));
		this.setSize(400,50);
		JTextField field = new JTextField();
		field.setHorizontalAlignment(SwingConstants.LEFT);
		field.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		field.setText(textToShow.getText());
		field.setBackground( Color.white );
		field.setOpaque( true );
		field.setEditable(false);
		field.setEnabled(false);
		field.setDisabledTextColor(Color.BLACK);
		this.add(field,BorderLayout.WEST);
		setHighlight(textToShow, field);
		//resultUsersNoteDocumentɑꍇ́AʂMouseListener
		if(documentURI.startsWith(URIObject.HEADER + URIObject.USERS_NOTE)){
			field.addMouseListener(new UsersNoteResultPanelMouseListener(index,documentURI));
		}else{
			field.addMouseListener(new ResultPanelJTextFieldMouseListener(index,documentURI));
		}
	}
	public static ResultPanel getInstance(TextToShow textToShow, String documentURI,int index) {
		return new ResultPanel(textToShow, documentURI,index); 
	}
	
	private void setHighlight(TextToShow textToShow, JTextField field){
		Highlighter hilite = field.getHighlighter();
		DefaultHighlightPainter hilightPainter = new DefaultHighlightPainter(Color.yellow);
		try{
			hilite.addHighlight(textToShow.getIndex(), textToShow.getIndex()+textToShow.getLength(), hilightPainter);	
		}catch(Exception e){
			System.out.println(e);
		}
	}
	
	/*
	 * ResultUsersNoteDocumentɑĂꍇɁA
	 * YUsersNoteJ߂MouseListener
	 */
	class UsersNoteResultPanelMouseListener implements MouseListener{
		UsersNote usersNote;
		String documentURI;
		int index;
		String name;
		private JWindow window;
		public UsersNoteResultPanelMouseListener(int index, String documentURI){
			this.index = index;
			this.documentURI = documentURI;
			this.usersNote = (UsersNote)URISolver.getUsersNote(documentURI);
		}
		public void mouseClicked(MouseEvent e) {
			if(e.getButton() == MouseEvent.BUTTON1 && !WorkspaceWindow.getInstance().isAlt()){
				if(e.getClickCount() == 1){
					GSTextEditor gsTextEditor = new GSTextEditor(usersNote, name);
					SGSHTMLEditorTextPane gsHTMLEditorTextPane = gsTextEditor.getGSEditorTextPane().getSGSHTMLEditorTextPane();
					gsTextEditor.setVisible(true);
					if(gsHTMLEditorTextPane != null){
						gsHTMLEditorTextPane.requestFocus();
						gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane, index));
					}
				}
			} else if (e.getButton() == MouseEvent.BUTTON3 || e.getButton() == MouseEvent.BUTTON1) {
				JLabel label = new JLabel("<html><b><font color='red' size='5'>Jump-operation is not applicable<br>to a user's note.</font></b></html>");
				JPanel panelToDisplayInformation = new JPanel();
				panelToDisplayInformation.add(label,BorderLayout.CENTER);
				if (window == null) window = new JWindow();
				window.getContentPane().setLayout(new BorderLayout());
				window.getContentPane().add(label,BorderLayout.CENTER);
				Point orig_p = resultPanel.getLocationOnScreen();
				Point p = new Point(orig_p.x+50, orig_p.y-10);
				window.setLocation(p);
				window.pack();
				window.setVisible(true);
			}
		}
		public void mouseEntered(MouseEvent e) {}

		public void mouseExited(MouseEvent e) {
			if(this.window != null){
				this.window.setVisible(false);
			}
		}

		public void mousePressed(MouseEvent e) {}

		public void mouseReleased(MouseEvent e) {}
	}
	
	class ResultPanelJTextFieldMouseListener implements MouseListener{
		protected Spread spread;
		protected String documentURI;
		protected int index;

		public ResultPanelJTextFieldMouseListener(int index,String documentURI){
			this.spread = (Spread)URISolver.getSpreadByDocumentURI(documentURI);
			this.documentURI = documentURI;
			this.index = index;
		}
		
		public void mouseClicked(MouseEvent e) {
			GSResource res = URISolver.getResource(documentURI);
			if (res == null) {
				System.out.println(String.format("Error: Spread of resouce %s is not found", documentURI));
				return;
			}
			if (!(res instanceof SmartDocument)) return;
			SmartDocument doc = (SmartDocument)res;
			if (!doc.isIDAT()) {
				return;
			} 
			IDAT idat = (IDAT)doc;
			if(e.getClickCount() == 1){
				int idat_index = idat.getIDATIndex();
				if(e.getButton() == MouseEvent.BUTTON1 && !WorkspaceWindow.getInstance().isAlt()){
					if(spread != null){
						GSEditor gsEditor = GSEditor.createCompactGSEditor(spread);
						SGSHTMLEditorTextPane gsHTMLEditorTextPane = null;
						switch (idat_index) {
						case 1:  
							gsEditor.getSMLTabbedPane().setPanelToShow(1);
							gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getFirstIDAT().getSGSHTMLEditorTextPane();
							break;
						case 2:  
							gsEditor.getSMLTabbedPane().setPanelToShow(2);
							gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getSecondIDAT().getSGSHTMLEditorTextPane();
							break;
						case 3:  
							gsEditor.getSMLTabbedPane().setPanelToShow(3);
							gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getThirdIDAT().getSGSHTMLEditorTextPane();
							break;
						default: 		
							System.out.println("Error in ResultPanelJTextFieldMouseListener");
							return;
						}
						gsEditor.setVisible(true);
						if(gsHTMLEditorTextPane != null){
							gsHTMLEditorTextPane.requestFocus();
							gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane, index));
						}
					}
				} else if(e.getButton() == MouseEvent.BUTTON3 || e.getButton() == MouseEvent.BUTTON1) {
					WorkspaceWindow window = WorkspaceWindow.getInstance();
					GSTabbedPane tbp = null;
					if(spread != null){
						if (window.getSpread() == null) {
							window.setSpread(spread);
							window.setImageSearch(spread.toString());
						} else if (!window.getSpread().equals(spread)) {
							window.setSpread(spread);
							window.setImageSearch(spread.toString());
						}
						SpreadCanvas canvas = WorkspaceWindow.getInstance().getSpreadCanvas();
						canvas.imageLabel.showImage();
						tbp = WorkspaceWindow.getInstance().getTabbedPane();
						tbp.setSelectedIndex(idat_index-1);
					}
					tbp.emphasize(idat_index,index,length);
				}
			}
		}

		public void mouseEntered(MouseEvent e) {}

		public void mouseExited(MouseEvent e) {}

		public void mousePressed(MouseEvent e) {}

		public void mouseReleased(MouseEvent e) {}

	}
	class GSEditorFocusListener implements FocusListener{
		protected SGSHTMLEditorTextPane gsHTMLEditorTextPane;
		protected int index;
		public GSEditorFocusListener(SGSHTMLEditorTextPane gsHTMLEditorTextPane,int index){
			this.gsHTMLEditorTextPane = gsHTMLEditorTextPane;
			this.index = index;
		}
		public void focusGained(FocusEvent e1) {
			gsHTMLEditorTextPane.setCaretPosition(index);
			Highlighter hilite = gsHTMLEditorTextPane.getHighlighter();
			DefaultHighlightPainter hilightPainter = new DefaultHighlightPainter(Color.yellow);
			try{
				hilite.addHighlight(this.index, index + length, hilightPainter); // 20080919 hashimoto
			}catch(Exception e2){
				e2.printStackTrace();
			}
			
		}
		public void focusLost(FocusEvent e) {
//			gsHTMLEditorTextPane.getHighlighter().removeAllHighlights();
			gsHTMLEditorTextPane.removeFocusListener(this);
		}
		
	}
}
