/* $Id: SaveLineSegmentsAndDscCompileAction.java 626 2013-01-13 18:51:36Z shayashi $ */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.DSCFileMaker;
import sml_editor.logical.LineDirection;

public class SaveLineSegmentsAndDscCompileAction implements ActionListener {
	
	private LineSegEditor editor;
	private Spread spread;
	public SaveLineSegmentsAndDscCompileAction(LineSegEditor parent){
		this.editor = parent;
	}
	public SaveLineSegmentsAndDscCompileAction(Spread spread){
		this.spread = spread;
	}
	public void dscCompile(){
		String folderPath = Spread.DSC_FOLDER_PATH+spread.getSpreadDirParent().getPath();
		String filename = spread.getFileNameWithoutExtension();
		String filetype = spread.getFileNameExtension();
		String lineDirectionType;
		if (spread.getLineDirection() == LineDirection.HORIZONTAL) {
			lineDirectionType = "HORIZONTAL";
		} else if (spread.getLineDirection() == LineDirection.VERTICAL) {
			lineDirectionType = "VERTICAL";
		} else {
			lineDirectionType = "UNDEFINED";
		}
		new DSCFileMaker(spread).saveLineSegmentsAndDscCompile(folderPath, filename, filetype, lineDirectionType);
	}
	public void actionPerformed(ActionEvent e) {
		this.spread = this.editor.getSpread();
		this.dscCompile();
	}
}
