package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorSelectMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorTiltImagePanelLevelLineMode;
import smart_gs.smleditor.swingui.LineSegEditor;

public class LineSegEditorTiltImagePanelUpDownActionListener implements	ActionListener {
	LineSegEditor editor;
	double chageDegree;
	
	public LineSegEditorTiltImagePanelUpDownActionListener(LineSegEditor editor,
			LineSegEditorTiltImagePanel lineSegEditorTiltImagePanel, double degree) {
		this.editor = editor;
		this.chageDegree = degree;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		LineSegEditorTiltImagePanel tiltpanel = editor.getTiltPanel();
		LineSegEditorMode mode = this.editor.getMode();
		if (mode instanceof LineSegEditorTiltImagePanelLevelLineMode) {
			((LineSegEditorTiltImagePanelLevelLineMode)mode).resetLine();
		}
		editor.pushUndoStack();
		double degree = tiltpanel.getDegree();
		degree += this.chageDegree;
		tiltpanel.setDegree(degree);
		this.editor.tilt();
		this.editor.setMode(new LineSegEditorSelectMode(this.editor));
	}

}
