package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JOptionPane;

import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;

public class LineSegEditorDeleteActionListener implements ActionListener {
	LineSegEditor editor;

	public LineSegEditorDeleteActionListener(LineSegEditor editor) {
		this.editor = editor;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		editor.pushUndoStack();
		String input = JOptionPane.showInputDialog("Index of line segment to delete:", "");
		if(input == null){
			return;
		}

		LineSegEditorDeleteActionProcessor prc = new LineSegEditorDeleteActionProcessor(input,this.editor.getLinesForEdit());
		prc.process();
		if (prc.isCanceled()) return;
		this.editor.pushUndoStack();
		this.editor.setLinesForEdit(prc.getLines());
		this.editor.rewriteLineSegIndexes();
		this.editor.invalidate();
		this.editor.validate();
		this.editor.repaint();
	}
}

