/* $Id: DefaultToolBar.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.action.LineSegEditorChangeSizeAction;
import smart_gs.drawing_tool.action.LineSegEditorRotateAction;
import smart_gs.drawing_tool.action.LineSegSelectActionListener;
import smart_gs.logical.Preference;
import smart_gs.network.Constants;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.action.DeleteDscFileAction;
import smart_gs.swingui.toolbar.action.DeleteLineSegmentsFileAction;
import smart_gs.swingui.toolbar.action.LineSegEditorChangeIndexActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDivideActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDeleteActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDrawActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDrawRectForMouseActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDrawRectForTouchPanelActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorSemiAutomaticLineSegmentationActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorTiltImagePanelLevelLineActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorTiltImagePanel;
import smart_gs.swingui.toolbar.action.LineSegEditorUndoActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorZoomInOutActionListener;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsInSegfoFormatAction;
import smart_gs.swingui.toolbar.action.DscCompileAction;
import smart_gs.swingui.toolbar.action.ImportDscFileAction;
import smart_gs.swingui.toolbar.action.LineSegDscInformationAction;
import smart_gs.swingui.toolbar.action.ReadSegmentInfoAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;


@SuppressWarnings("serial")
public class LineSegEditorToolBar extends JToolBar{

	
	private LineSegEditor editor;
	private ButtonGroup modeButtonGroup;
	private int pointingDeviceType = Preference.getInstance().getPointingDeviceType();

	public LineSegEditorToolBar(LineSegEditor editor){
		
		this.editor = editor;
		
		setOrientation(VERTICAL);
		setLayout(new GridLayout(0,1));

		
		JButton  select = new JButton("Select");
		select.addActionListener(new LineSegSelectActionListener(this.editor));
		select.setToolTipText("Draw Line Segment");
		this.add(select);
		select.setSelected(true);
		
		JButton draw = new JButton("Draw");
		draw.addActionListener(new LineSegEditorDrawActionListener(this.editor));
		draw.setToolTipText("Draw Line Segment");
		this.add(draw);
		
		JButton drawRect = new JButton("Draw Rect");
		if (pointingDeviceType == GSConstants.TOUCH_PANEL) 
			drawRect.addActionListener(new LineSegEditorDrawRectForTouchPanelActionListener(this.editor));
		else
			drawRect.addActionListener(new LineSegEditorDrawRectForMouseActionListener(this.editor));
		drawRect.setToolTipText("Draw Rectangle Line Segment");
		this.add(drawRect);
		
		JButton drawAuto1 = new JButton("Draw Auto 1");
		drawAuto1.addActionListener(new LineSegEditorSemiAutomaticLineSegmentationActionListener(this.editor));
		drawAuto1.setToolTipText("Semi-auto Draw Line Segment Mode");
		this.add(drawAuto1);

		JButton cut = new JButton("Divide");
		cut.addActionListener(new LineSegEditorDivideActionListener(this.editor,this));
		cut.setToolTipText("Cut Line Segment");
		this.add(cut);

		JButton move = new JButton("Change index");
		move.addActionListener(new LineSegEditorChangeIndexActionListener(this.editor));
		move.setToolTipText("Change Index");
		this.add(move);

		JButton delete = new JButton("Delete");
		delete.addActionListener(new LineSegEditorDeleteActionListener(this.editor));
		delete.setToolTipText("Delete Line");
		this.add(delete);

		JButton undo = new JButton("Undo");
		undo.addActionListener(new LineSegEditorUndoActionListener(this.editor));
		undo.setToolTipText("Undo the last change on line segments");
		this.add(undo);

		JButton zoomIn = new ZoomIn(new ImageIcon(GSConstants.ICON_PATH+"zoom_in.gif"));
		zoomIn.addActionListener(new LineSegEditorZoomInOutActionListener(this.editor,"ZoomIn"));
		zoomIn.setToolTipText("Zoom in");
		this.add(zoomIn);

		JButton zoomOut = new ZoomOut(new ImageIcon(GSConstants.ICON_PATH+"zoom_out.gif"));
		zoomOut.addActionListener(new LineSegEditorZoomInOutActionListener(this.editor,"ZoomOut"));
		zoomOut.setToolTipText("Zoom out");
		this.add(zoomOut);

		JButton changeSize = new JButton("Move & Resize");
		changeSize.addActionListener (new LineSegEditorChangeSizeAction(this.editor));
		changeSize.setToolTipText("Mode & Resize");
		this.add(changeSize);

		JButton rotate = new JButton("Rotate");
		rotate.addActionListener (new LineSegEditorRotateAction(this.editor));
		rotate.setToolTipText("Change Size");
		this.add(rotate);

		JButton saveLSeg = new JButton("Save");
		saveLSeg.addActionListener(new SaveLineSegmentsAction(this.editor));
		saveLSeg.setToolTipText("Save Line Segments");
		this.add(saveLSeg);

		JButton readLSegSegfo = new JButton("Read Segfo File");
		readLSegSegfo.addActionListener(new ReadSegmentInfoAction(this.editor));
		readLSegSegfo.setToolTipText("Read Segfo File");
		this.add(readLSegSegfo);

		JButton saveLSegSegfo = new JButton("Save as Segfo File");
		saveLSegSegfo.addActionListener(new SaveLineSegmentsInSegfoFormatAction(this.editor));
		saveLSegSegfo.setToolTipText("Save as Segfo File");
		this.add(saveLSegSegfo);

		JButton infoLSeg = new JButton("Info");
		infoLSeg.addActionListener(new LineSegDscInformationAction(this.editor));
		infoLSeg.setToolTipText("Line Seg & DSC Information");
		this.add(infoLSeg);

		JButton deleteLSeg = new JButton("Delete File");
		deleteLSeg.addActionListener(new DeleteLineSegmentsFileAction(this.editor));
		deleteLSeg.setToolTipText("Delete Line Segments File");
		this.add(deleteLSeg);

		JButton createDSC = new JButton("Make DSC File");
		createDSC.addActionListener(new DscCompileAction(this.editor));
		createDSC.setToolTipText("Make DSC File");
		this.add(createDSC);

		JButton createLineSegAndDSC = new JButton("Save & Make DSC");
		createLineSegAndDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(this.editor));
		createLineSegAndDSC.setToolTipText("Save Line Seg & Make DSC File");
		this.add(createLineSegAndDSC);

		JButton deleteDSC = new JButton("Delete DSC File");
		deleteDSC.addActionListener(new DeleteDscFileAction(this.editor));
		deleteDSC.setToolTipText("Delete DSC File");
		this.add(deleteDSC);

		JButton importDSC = new JButton("Import DSC File");
		importDSC.addActionListener(new ImportDscFileAction(this.editor));
		importDSC.setToolTipText("Import DSC File");
		this.add(importDSC);
		
////		HERE HERE 2013.09.25
//		adjustToPointingDevice(0);
	}
	
	private class ZoomIn extends JButton implements ImageToolBarComponent {

		ZoomIn(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_IN;
		}
	}

	private class ZoomOut extends JButton implements ImageToolBarComponent {

		ZoomOut(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_OUT;
		}
	}
}
