/* $Id: CloseUpViewer.java 741 2013-09-09 04:48:44Z minao $ */
package smart_gs.smleditor.swingui;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.logical.Region;
import smart_gs.logical.URICreator;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.SetIcon;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.ImageCropper;

public class CloseUpViewer  {

	int magnification = 20;

	JFrame frame = new JFrame();
	JPanel current_panel = new JPanel();
	Image original_image;
	JPanel panel_100 = new JPanel();
	JPanel panel_150 = new JPanel();
	JPanel panel_200 = new JPanel();
	JPanel panel_300 = new JPanel();
	JPanel panel_500 = new JPanel();
	private Point loc = null;
	private MouseEvent start;
	Window window;
	private Region region;
	private static int lastScale = 300;

	public CloseUpViewer (Image arg, final Region region) {
		this.region = region;
		frame.setAlwaysOnTop(true);
		frame.setResizable(false);
		// If the region is close-up rectangle,
		// delete it when the window is closed
		frame.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				if (region.getTypeString().equals(URICreator.CLOSE_UP_RECTANGLE)) {
					new DeleteRegionAction(region).execute();
				}
			}
		});
		SetIcon.setIcon(frame);
		original_image = arg;
		window = frame;
		loc = window.getLocation();

		try {
			panel_100 = createElementViewPanelMagnified(100);
		} catch (NoWayToShowException e){
			e.printStackTrace();
		}
		try {
			panel_150 = createElementViewPanelMagnified(150);
		} catch (NoWayToShowException e){
			e.printStackTrace();
		}
		try {
			panel_200 = createElementViewPanelMagnified(200);
		} catch (NoWayToShowException e){
			e.printStackTrace();
		}
		try {
			panel_300 = createElementViewPanelMagnified(300);
		} catch (NoWayToShowException e){
			e.printStackTrace();
		}
		try {
			panel_500 = createElementViewPanelMagnified(500);
		} catch (NoWayToShowException e){
			e.printStackTrace();
		}
		
		if (lastScale == 100) {
			current_panel = panel_100;
		} else if (lastScale == 150) {
			current_panel = panel_150;
		} else if (lastScale == 200) {
			current_panel = panel_200;
		} else if (lastScale == 300) {
			current_panel = panel_300;
		} else {
			current_panel = panel_500;
		}
		frame.getContentPane().add(current_panel, BorderLayout.CENTER);
		frame.pack();
		PointerInfo pointerInfo = MouseInfo.getPointerInfo();
		Point p = pointerInfo.getLocation();
		frame.setLocation(p.x-60,p.y-15);
		frame.setVisible(true);
	}



	public JPanel createElementViewPanelMagnified(int percent) throws NoWayToShowException {
		Image resulted_image;
		int width = original_image.getWidth(null);
		resulted_image = original_image.getScaledInstance((int)(width*(percent/100.00)*0.8),-1,Image.SCALE_SMOOTH);
		JLabel label = new JLabel();
		ImageIcon icon = new ImageIcon(resulted_image);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		label.setIcon(icon);
		panel.add(label,BorderLayout.CENTER);
		panel.addMouseMotionListener(new TheListener());
		panel.addMouseListener(new TheListener());
		return panel;
	}

	class TheListener implements MouseMotionListener, MouseListener{

		public void mouseMoved(MouseEvent me){}
		public void mouseDragged(MouseEvent me){
			loc = window.getLocation();
			if (start == null) start = me;
			int x = loc.x - start.getX() + me.getX();
			int y = loc.y - start.getY() + me.getY();
			window.setLocation(x, y);
		}
		@Override
		public void mouseClicked(MouseEvent e) {
			JPopupMenu menu = new JPopupMenu();
			JMenuItem title = new JMenuItem("Magnify");
			menu.add(title);
			menu.addSeparator();
			JMenuItem onehundred = new JMenuItem("100%");
			menu.add(onehundred);
			JMenuItem onehundredfifty = new JMenuItem("150%");
			menu.add(onehundredfifty);
			JMenuItem twohundred = new JMenuItem("200%");
			menu.add(twohundred);
			JMenuItem threehundred = new JMenuItem("300%");
			menu.add(threehundred);
			JMenuItem fivehundred = new JMenuItem("500%");
			menu.add(fivehundred);
			JMenuItem close = new JMenuItem("Close");
			menu.add(close);


			onehundred.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_100);
					current_panel = panel_100;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
					lastScale = 100;
				}
			});

			onehundredfifty.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_150);
					current_panel = panel_150;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
					lastScale = 150;
				}
			});

			twohundred.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_200);
					current_panel = panel_200;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
					lastScale = 200;
				}
			});

			threehundred.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_300);
					current_panel = panel_300;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
					lastScale = 300;
				}
			});
			
			fivehundred.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.remove(current_panel);
					frame.add(panel_500);
					current_panel = panel_500;
					frame.pack();
					frame.setVisible(true);
					frame.repaint();
					lastScale = 500;
				}
			});

			close.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					frame.dispose();
				}
			});

			menu.show(e.getComponent(), e.getX(), e.getY());
		}

		@Override
		public void mouseEntered(MouseEvent arg0) {
			// TODO Auto-generated method stub

		}

		@Override
		public void mouseExited(MouseEvent arg0) {
			// TODO Auto-generated method stub

		}

		@Override
		public void mousePressed(MouseEvent arg0) {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void mouseReleased(MouseEvent arg0) {
			// TODO Auto-generated method stub

		}
	}
}

