/* $Id: DeskTopFolder.java 428 2011-10-17 00:45:55Z minao $ */
package smart_gs.reasoning_web.desktop.logical;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.GSVersion;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopFolderView;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.swingui.WorkspaceWindow;

public class DeskTopFolder extends DesktopElement implements URIBearer {
	private String uri;
	private String originalURI;
	private String oldVersionURI;
	private String version;
	
	private List<ShortCut> shortcuts;
	private List<DeskTopFolder> folders;
	
	public DeskTopFolder(DeskTopFolder parent,String name){
		super(parent,name,"<xml></xml>");
		//20071126 shimizu wrote;
		this.setName(name);
		this.shortcuts = new ArrayList<ShortCut>();
		this.folders = new ArrayList<DeskTopFolder>();
		this.setURIs();
		this.setVersion(GSVersion.getVersion());
	}
	public DeskTopFolder(String name){
		super(ReasoningWebDesktop.getInstance().getRootFolder(),name,"<xml></xml>");
		this.shortcuts = new ArrayList<ShortCut>();
		this.folders = new ArrayList<DeskTopFolder>();
		this.setURIs();
		this.setVersion(GSVersion.getVersion());
	}
	public void add(DesktopElement element){
		if(element instanceof ShortCut){
			this.shortcuts.add((ShortCut)element);
		}else if(element instanceof DeskTopFolder){
			DeskTopFolder folder = (DeskTopFolder)element;
			this.folders.add(folder);
			folder.setParent(this);
		}
		this.notifyChange();
		ReasoningWebFrame.getInstance().getDesktopPanel().updateAll();
	}
	@Override
	public void setParent(DeskTopFolder parent) {
		this.parent = parent;
		//this.updateURI();	
	}
	public void updateURI() {
		this.uri = this.createURI();
		List<DeskTopFolder> folders = this.getFolders();
		for (int i = 0; i < folders.size(); i++) {
			folders.get(i).updateURI();
		}
	}
	
	public void remove(DesktopElement desktopelement){
		if(desktopelement instanceof ShortCut){
			this.shortcuts.remove((ShortCut)desktopelement);
		}else if(desktopelement instanceof DeskTopFolder){
			this.folders.remove((DeskTopFolder)desktopelement);
		}
		this.notifyChange();
		WorkspaceWindow.setUpdated(true);
	}
	
	public void initialize(){
		this.shortcuts.clear();
		this.folders.clear();
	}
	
	
	public List<ShortCut> getShortCuts(){
		return this.shortcuts;
	}
	public List<DeskTopFolder> getFolders(){
		return this.folders;
	}
	
	public void open() {
		ReasoningWebFrame.getInstance().setMainPanel(new FolderPanel(this));
	}
	@Override
	public DesktopElementView createView() {
		return new DesktopFolderView();
	}
	public List<DesktopElement> getAllElements() {
		List<DesktopElement> elements = new ArrayList<DesktopElement>();
		elements.addAll(this.shortcuts);
		elements.addAll(this.folders);
		return elements;
	}
	public DeskTopFolder getFolder(Point point) {
		for(int i=0;i<this.folders.size();i++){
			if(this.folders.get(i).getView().contains(point)){
				return this.folders.get(i);
			}
		}
		return null;
	}
	public DeskTopFolder getFolderOtherThan(Point point, DeskTopFolder folder) {
		for(int i=0;i<this.folders.size();i++){
			DeskTopFolder target = this.folders.get(i);
			if(!target.equals(folder) && target.getView().contains(point)){
				return target;
			}
		}
		return null;
	}
	public DeskTopFolder getFolder(String name) {
		for(int i=0;i<this.folders.size();i++){
			if(this.folders.get(i).getName().equals(name)){
				return this.folders.get(i);
			}
		}
		return null;
	}
	public Element createXMLElement(Document document){	
		Element element = document.createElement("desktopFolder");
		element.setAttribute("name",this.name);
		element.setAttribute(GSResource.URI, this.uri);
		element.setAttribute(GSResource.ORIGINAL_URI, this.originalURI);
		element.setAttribute(GSResource.OLD_VERSION_URI, this.getOldVersionURI());
		element.setAttribute(GSResource.VERSION, this.version);
		element.setAttribute("source",this.memo.getSource());
		for(int i=0;i<this.folders.size();i++){
			Element elem = this.folders.get(i).createXMLElement(document);
			element.appendChild(elem);
		}
		
		for(int i=0;i<this.shortcuts.size();i++){
			Element elem = this.shortcuts.get(i).createXMLElement(document);
			element.appendChild(elem);
		}
		return element;
	}

	public static DeskTopFolder restore(Element element) {
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		DeskTopFolder folder = new DeskTopFolder(name);
		folder.setString(source);
		folder.setURIs(uri, originalURI);
		folder.setOldVersionURI(oldVersionURI);
		folder.setVersion(version);
		NodeList list = element.getElementsByTagName("desktopFolder");

		for(int i=0;i<list.getLength();i++){
			DeskTopFolder childFolder = DeskTopFolder.restore((Element)list.item(i));
			folder.add(childFolder);
		}
		
		list = element.getElementsByTagName("shortcut");
		for(int i=0;i<list.getLength();i++){
			if(!list.item(i).getParentNode().equals(element)){
				continue;
			}
			ShortCut shortcut = ShortCut.restore((Element)list.item(i));
			folder.add(shortcut);
			shortcut.setParent(folder);
		}
		
		return folder;
	}
	
	// TODO \łȂ̂̕\𓝈ꂹII
	public JPanel createElementViewPanel() throws NoWayToShowException {
		throw new NoWayToShowException();
	}
	public JPanel createElementViewPanel(int width, int height) throws NoWayToShowException {
		JPanel panel = new JPanel();
		panel.add(new JLabel("DeskTopFolder"));
		panel.setSize(width, height);
		return panel;
	}

	public void show() {
		this.open();
	}
	public boolean hasFolder(String name) {
		for(int i=0;i<this.folders.size();i++){
			if(this.folders.get(i).getName().equals(name)){
				return true;
			}
		}
		return false;
	}
	public GSResource getResource(String uri) {
		for(int i=0;i<this.shortcuts.size();i++){

			GS_RWElement resource =  (GS_RWElement) this.shortcuts.get(i).getResource();
			if(resource.getURI().equals(uri)){
				return (GSResource)resource;
			}
			resource = this.shortcuts.get(i).getMemo().getSegments(uri);
			if(resource != null){
				return (GSResource)resource;
			}
		}
		for(int i=0;i<this.folders.size();i++){
			GSResource resource = this.folders.get(i).getResource(uri);
			if(resource != null){
				return resource;
			}
		}
		return null;
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.DESKTOP_FOLDER;
	}
	public void setURIs() {
		this.originalURI = this.createURI();
		this.setURI(this.originalURI);
	}
	public void setURI(String uri) {
		this.uri = uri;
	}
	public String getURI() {
		return this.uri;
	}
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
	}
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public String getVersion() {
		return this.version;
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}
	@Override
	public void setVersion(String version) {
		this.version = version;
	}
	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}
	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;
	}
}
