package smart_gs.network;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import smart_gs.debugprint.Debugprint;

import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectList extends JList implements ListSelectionListener {
	private List<HCPProject> projects;
	private String location;
	private boolean belongToProjectExplorer;
	
	public ProjectList(List<HCPProject> projects, String location, boolean belongToProjectExplorer) {
		this.setProjects(projects);
		this.belongToProjectExplorer = belongToProjectExplorer;
		this.location = location;
		DefaultListModel model = new DefaultListModel();
		for(int i = 0; i < projects.size(); i++) {
			model.addElement(projects.get(i).name);
		}
		this.setModel(model);
		this.addListSelectionListener(this);
	}

	public void setProjects(List<HCPProject> projects) {
		this.projects = projects;
	}

	public List<HCPProject> getProjects() {
		return projects;
	}
	

	@Override
	public void valueChanged(ListSelectionEvent arg0) {
		if (!this.belongToProjectExplorer) return;
		int index = this.getSelectedIndex();
		HCPProject project = this.projects.get(index);
		ProjectExplorer.getInstance().setSelectedProject(project, this.location);
		ProjectExplorer.getInstance().browseSelectedProject(project, this.location);
		ProjectExplorer.getInstance().getProjectContentPreviewPanel().reset();
		
	}


}
