package smart_gs.network;


import java.awt.BorderLayout;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ProjectExplorerMenuBar extends JMenuBar {

	static final String AUTHENTICATE = Constants.AUTHENTICATE;
	static final String COMPARE = Constants.COMPARE;
	
	// workspace
	static final String OPEN = Constants.OPEN;
	static final String UPDATE = Constants.UPDATE;
	static final String UPLOAD = Constants.UPLOAD;
	static final String REGISTER = Constants.REGISTER;
	static final String DOWNLOAD = Constants.DOWNLOAD;
	static final String SAVE_AS = Constants.SAVE_AS;
	static final String NEW = Constants.NEW;
	static final String REMOVE = Constants.REMOVE;
	static final String FETCH = Constants.FETCH;
//	static final String ADD_IMAGE = Constants.ADD_IMAGE;
	
	private JPanel workspaceButtons;
	private JPanel repositoryButtons;
	private JPanel otherButtons;
	
	public ProjectExplorerMenuBar() {
		this.workspaceButtons = new JPanel();
		this.workspaceButtons.setBorder(new TitledBorder("Workspace"));
		this.repositoryButtons = new JPanel();
		this.repositoryButtons.setBorder(new TitledBorder("Repository"));
		this.otherButtons = new JPanel();
		this.otherButtons.setBorder(new TitledBorder(""));

		ProjectActionButton auth = new ProjectActionButton(new ProjectAction(AUTHENTICATE));
		this.otherButtons.add(auth);

		ProjectActionButton compare = new ProjectActionButton(new ProjectAction(COMPARE));
		this.otherButtons.add(compare);
		
		ProjectActionButton createNewProj = new ProjectActionButton(new ProjectAction(NEW));
		this.workspaceButtons.add(createNewProj);
		
		//import
		ProjectActionButton register = new ProjectActionButton(new ProjectAction(REGISTER));		
		this.workspaceButtons.add(register);

		ProjectActionButton open = new ProjectActionButton(new ProjectAction(OPEN));
		this.workspaceButtons.add(open);
				
		ProjectActionButton update = new ProjectActionButton(new ProjectAction(UPDATE));
		this.workspaceButtons.add(update);

		//commit
		ProjectActionButton upload = new ProjectActionButton(new ProjectAction(UPLOAD));
		this.workspaceButtons.add(upload);

		ProjectActionButton remove = new ProjectActionButton(new ProjectAction(REMOVE));
		this.workspaceButtons.add(remove);
		
		//checkout
		ProjectActionButton download = new ProjectActionButton(new ProjectAction(DOWNLOAD));
		this.repositoryButtons.add(download);
		
		//export
		ProjectActionButton saveAs = new ProjectActionButton(new ProjectAction(SAVE_AS));
		this.repositoryButtons.add(saveAs);
		
		ProjectActionButton fetch = new ProjectActionButton(new ProjectAction(FETCH));
		this.repositoryButtons.add(fetch);
		
		this.add(this.otherButtons);
		this.add(this.workspaceButtons);
		this.add(this.repositoryButtons);
	}
	
	class ProjectActionButton extends JButton {
		
		public ProjectActionButton(ProjectAction projectAction) {
			super(projectAction);
		}
		
		public String relevantLocation() {
			String name =(String) ((ProjectAction)this.getAction()).getValue(AbstractAction.NAME);
			if (name.equals(OPEN) || name.equals(UPDATE) ||
					name.equals(UPLOAD) || name.equals(REGISTER) ||
					name.equals(REMOVE)) {
				return Constants.WORKSPACE;
			}
			if (name.equals(DOWNLOAD) || name.equals(SAVE_AS) || name.equals(FETCH)) {
				return Constants.REPOSITORY;
			} else {
				return Constants.NONE;
			}
		}
	}

}
