package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import smart_gs.debugprint.Debugprint;
import smart_gs.swingui.ButtonDialog;
import smart_gs.swingui.WorkspaceWindow;


import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectHistory;

public class ExportOptionDialog extends ButtonDialog implements ListSelectionListener {
	private HCPProject project;
	private JTextField nameField;
	private JList revisions;
	private int selectedRevision = -1;
	private List<HCPProjectHistory> histories;
	private JPanel namePanel;
	private JPanel revisionPanel;
	
	public ExportOptionDialog(HCPProject project) {
		super(ProjectExplorer.getInstance(), "Export Option: " + project.name);
		this.project = project;
		this.revisions = new JList();
		this.histories = new ArrayList<HCPProjectHistory>();
		this.setTitle("Export Option: " + project.name);
		this.project = project;
		try {
			this.makeRevisionList();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			new ShowResultDialog("Export", e).setVisible(true);
		} catch (UnauthorizedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			new ShowResultDialog("Export", e).setVisible(true);
		}
		JScrollPane sPane = new JScrollPane(this.revisions);
		sPane.setPreferredSize(new Dimension(350, 20));
		this.nameField = new JTextField();
		this.nameField.setPreferredSize(new Dimension(350, 20));
		this.nameField.setText(this.project.name);
		this.namePanel = new JPanel();
		this.namePanel.setBorder(new TitledBorder("Name"));
		this.namePanel.add(this.nameField);
		this.revisionPanel = new JPanel();
		this.revisionPanel.setBorder(new TitledBorder("Revision"));
		this.revisionPanel.add(sPane);
		this.add(this.namePanel, BorderLayout.NORTH);
		this.add(this.revisionPanel, BorderLayout.CENTER);
		this.setSize(400,100);
	}
	
	private void makeRevisionList() throws IOException, UnauthorizedException {
		ProjectHandler handler = ProjectHandler.getInstance();
		this.histories = handler.fetchHistories(this.project.name, 0, 0);
		DefaultListModel model = new DefaultListModel();
		Debugprint.from();
		Debugprint.message("this.histories.size():" + this.histories.size());
		for (int i = 0; i < this.histories.size(); i++) {
			Debugprint.message("this.histories.get(i):" + this.histories.get(i));
			model.addElement(this.histories.get(i).revision + ": " + this.histories.get(i).remarks);
		}
		this.revisions.setModel(model);
		this.revisions.addListSelectionListener(this);
	}

	@Override
	public void ok() {
		String name = this.project.name;
		int revision = this.selectedRevision;
		String newName = this.nameField.getText();
		if (newName == null) {
			newName = name;
		}
		if (revision < -1) {
			JOptionPane.showMessageDialog(this,
					"Select Revision.", "Message",
					JOptionPane.WARNING_MESSAGE);
		} else {
			try {
				ProjectHandler.getInstance().getController().exportProject(name, revision, newName);
				ProjectExplorer.getInstance().update();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				new ShowResultDialog("Export", e).setVisible(true);
			} catch (UnauthorizedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				new ShowResultDialog("Export", e).setVisible(true);
			} catch (HCPClientException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				new ShowResultDialog("Export", e).setVisible(true);
			}
		}
	}

	@Override
	public void cancel() {
		this.dispose();
	}

	@Override
	public void valueChanged(ListSelectionEvent arg0) {
		this.selectedRevision = this.revisions.getSelectedIndex();
	}	
}