/* $Id: EditMenu.java 793 2013-12-09 04:34:30Z ohura $ */
package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.GSMarkupAction;
import smart_gs.swingui.toolbar.GSRemoveTagAction;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.toolbar.action.CopyAction;
import sml_editor.swingui.toolbar.action.CutAction;
import sml_editor.swingui.toolbar.action.MarkupAction;
import sml_editor.swingui.toolbar.action.PasteAction;
import sml_editor.swingui.toolbar.action.RedoAction;
import sml_editor.swingui.toolbar.action.RemoveTagAction;
import sml_editor.swingui.toolbar.action.UndoAction;

@SuppressWarnings("serial")
public class EditMenu extends JMenu implements ActionListener{
	protected EditorTextPane  textPane;
	protected GSEditorToolBar  gsEditorToolBar;

	protected CopyAction copyAction;
	protected CutAction cutAction;
	protected PasteAction pasteAction;
	protected MarkupAction markupAction;
	protected UndoAction undoAction;
	protected RedoAction redoAction;
	protected RemoveTagAction removeTagAction;
	
	protected JMenuItem markup;
	protected JMenuItem removeTag;
	protected JMenuItem anchor;
	private JMenuItem source;
	private JMenuItem browse;
	private JMenuItem edit;
	
	public EditMenu(String title, GSEditorTextPane textPane,GSEditorToolBar gsEditorToolBar) {
		super(title);
		this.textPane = textPane;
		this.gsEditorToolBar = gsEditorToolBar;
		copyAction = new CopyAction();
		cutAction = new CutAction();
		pasteAction = new PasteAction();
		markupAction = new MarkupAction();
		undoAction = new UndoAction();
		undoAction.setKeyEvent(false);
		redoAction = new RedoAction();
		redoAction.setKeyEvent(false);
		removeTagAction = new RemoveTagAction();
		
//		browse = new JMenuItem("Browse");
//		browse.addActionListener(this);
//		edit = new JMenuItem("Edit");
//		edit.addActionListener(this);
//		source = new JMenuItem("Source");
//		source.addActionListener(this);
//		this.add(source);
//		this.add(edit);
//		this.add(browse);
//		this.addSeparator();
		
		
		JMenuItem copy = new JMenuItem("Copy", new ImageIcon("./icons/copy.gif"));
		copy.addActionListener(copyAction);
		copy.setFocusable(false);
		copy.setAccelerator(KeyStroke.getKeyStroke("ctrl C"));
		this.add(copy);
		
		JMenuItem cut = new JMenuItem("Cut", new ImageIcon("./icons/cut.gif"));
		cut.addActionListener(cutAction);
		cut.setFocusable(false);
		cut.setAccelerator(KeyStroke.getKeyStroke("ctrl X"));
		this.add(cut);
		
		JMenuItem paste = new JMenuItem("Paste");
		paste.addActionListener(pasteAction);
		paste.setFocusable(false);
		paste.setAccelerator(KeyStroke.getKeyStroke("ctrl V"));
		this.add(paste);
		
		this.addSeparator();
		
		JMenuItem undo = new JMenuItem("Undo", new ImageIcon("./icons/undo.gif"));
		undo.addActionListener(undoAction);
		undo.setAccelerator(KeyStroke.getKeyStroke("ctrl Z"));
		this.add(undo);
		
		JMenuItem redo = new JMenuItem("Redo", new ImageIcon("./icons/redo.gif"));
		redo.setAccelerator(KeyStroke.getKeyStroke("ctrl Y"));
		redo.addActionListener(redoAction);
	
		this.add(redo);
		
//		2011.10.19 shayashi null poiter ł̂łƂ肠RgAEg
//		this.addSeparator();
		
//		this.markup = new JMenuItem("Mark up");
//		this.markup.addActionListener(markupAction);
//		this.markup.setFocusable(false);
//		markup.setAccelerator(KeyStroke.getKeyStroke("ctrl M"));
//		this.add(this.markup);
		
		
		this.removeTag = new JMenuItem("Remove Tag");
		this.removeTag.addActionListener(removeTagAction);
		//20080622 shimizu wrote
		//this.add(this.removeTag);
		copyAction.setEditorTextPane(this.textPane);
		cutAction.setEditorTextPane(this.textPane);
		pasteAction.setEditorTextPane(this.textPane);
		markupAction.setEditorTextPane(this.textPane);
		undoAction.setEditorTextPane(this.textPane);
		redoAction.setEditorTextPane(this.textPane);
		removeTagAction.setEditorTextPane(this.textPane);
		
//  Edit menu ́@Mark up RgAEgƂ̗]gƂāA
//		RgAEg   2011.10.19 shayashi
//		this.markup.removeActionListener(this.markupAction);
//		this.markupAction = new GSMarkupAction();
//		this.markupAction.setEditorTextPane(textPane);
//		this.markup.addActionListener(this.markupAction);
//		
//		this.removeTag.removeActionListener(this.removeTagAction);
//		this.removeTagAction = new GSRemoveTagAction();
		
	}
	public void setTextPane(EditorTextPane textPane){
		this.textPane = textPane;	
		copyAction.setEditorTextPane(this.textPane);
		cutAction.setEditorTextPane(this.textPane);
		pasteAction.setEditorTextPane(this.textPane);
		markupAction.setEditorTextPane(this.textPane);
		undoAction.setEditorTextPane(this.textPane);
		redoAction.setEditorTextPane(this.textPane);
		removeTagAction.setEditorTextPane(this.textPane);
	}
	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(source)){
			this.gsEditorToolBar.onSourcemode();
		}else if(e.getSource().equals(browse)){
			this.gsEditorToolBar.onBrowseMode();
		}else if(e.getSource().equals(edit)){
			this.gsEditorToolBar.onEditMode();
		}
	}
}
