package smart_gs.logical.filter;

import java.io.File;
import java.io.FilenameFilter;

import javax.imageio.ImageIO;

import smart_gs.util.CanonicalPathString;

// Filter for SpreadTree. Not for chooser!
//2011.1.17 shayashi added 2011.03.22 "dsc" added and make case-senseless. 20110330 changed by ImageIO.getReaderFormatNames()
public class ImageFileDirFilterForSpreadTree implements FilenameFilter{
	public boolean accept(File dir, String name) {
		String formatNames[] = ImageIO.getReaderFormatNames();
		File file = new File(CanonicalPathString.get(dir)+"/"+name);
//		files and dirs with forbidden names are invisible
		if(InvisibleName.isInvisible(name)) {
			return false;
		}
//		but the other directories are all visible.
		if(file.isDirectory()){
			return true;
		}
		else {
			for(int i=0;i<formatNames.length;i++){
				if (name.endsWith("."+formatNames[i])) return true;
			}
		}
		return false;
	}
}