package smart_gs.drawing_tool.state;

import java.awt.Graphics;

import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.GSMouseEvent;

public interface LineSegEditorState {
	public static int DEFAULT = 0;
	public static int UNISELECTED = 1;
	public static int MULTISELECTED = 2;
	
	public abstract void mouseClicked(GSMouseEvent e,LineSegEditorCanvas canvas);
	public abstract void mouseEntered(GSMouseEvent e,LineSegEditorCanvas canvas);
	public abstract void mouseExited(GSMouseEvent e,LineSegEditorCanvas canvas);
	public abstract void mousePressed(GSMouseEvent e,LineSegEditorCanvas canvas);
	public abstract void mouseReleased(GSMouseEvent e,LineSegEditorCanvas canvas);
	public abstract void mouseDragged(GSMouseEvent e,LineSegEditorCanvas canvas);
	public abstract void mouseMoved(GSMouseEvent e,LineSegEditorCanvas canvas);
	public abstract void paint(Graphics g,LineSegEditorCanvas canvas);
	public abstract void setMode(LineSegEditorMode mode);
	public abstract LineSegEditorMode getMode();
	public abstract int getType();
	public abstract void setParentLinesegEditor();
	public abstract LineSegEditor getParentLinesegEditor();
}