/* $Id: EraserMode.java 561 2012-09-05 04:28:55Z shayashi $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.List;

import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.logical.Region;
public class EraserMode extends DrawingModeAdapter {
	private Component startcomponent = null;
	private static Mode singleton = new EraserMode();

	public static Mode getInstance() {
		((EraserMode)singleton).reset();
		return singleton;
	}
	
	private void reset() {
		startcomponent = null;	
	}
	
	@Override
	public void mouseExited(GSMouseEvent e, SpreadCanvas canvas){
		super.mouseExited(e, canvas);
		if (startcomponent == null)	startcomponent = e.getComponent();
	}
	
	@Override
	public void mousePressed(GSMouseEvent e,SpreadCanvas canvas){
		if (startcomponent != null && (startcomponent != e.getComponent())) return;
		super.mousePressed(e, canvas);
		Region region = canvas.getRegion(e.getPoint());
		new DeleteRegionAction(region).execute();
	}
}
