package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.action.CloseUpViewerAction;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.CloseUpRectangleView;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.region.CloseUpRectangleRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class CloseUpRectangleMode extends DrawingModeAdapter {
	protected Component startcomponent = null;
	protected boolean out = false;
	private static Mode singleton = new CloseUpRectangleMode();
	
	protected Point2D start;
	protected Point2D end;
	
	private boolean temporary = true;


	public static Mode getInstance(){
		((CloseUpRectangleMode)singleton).reset();
		return singleton;
	}
	
	protected void reset() {
		startcomponent = null;
		out = false;
		start = null;
		end = null;
	}
	@Override
	public boolean isTemporary() {
		return temporary;
	}
	@Override
	public void setTemporary(boolean sw) {
		temporary = sw;
	}
	@Override
	public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
		if (startcomponent == null) startcomponent = e.getComponent();
		if (e.getComponent() == startcomponent) {
			out = false;
		} else {
			out = true;
		}
		setCursor(canvas);
	}
	
	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		if (startcomponent == null) { 
			startcomponent = e.getComponent();
		}
		super.mousePressed(e, canvas);
		this.start = e.getPoint();
		setCursor(canvas);
	}
	@Override
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		if(e.getComponent() != startcomponent){
			return ;
		}
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
		setCursor(canvas);
	}
	
	@Override
	public void mouseMoved(GSMouseEvent e,SpreadCanvas canvas) {
		if (startcomponent == null) startcomponent = e.getComponent();
		if (e.getComponent() == startcomponent) {
			out = false;
		} else {
			out = true;
			return;
		}
		if(startcomponent != null && (e.getComponent() != startcomponent)){
			return ;
		}
		setCursor(canvas);
	}
	
	@Override
	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		super.mouseReleased(e, canvas);
		if(start == null || end == null){
			return ;
		}

		if((end.getX() - start.getX()) > 10 &&  end.getY() - start.getY() > 10){
			Region reg = new CloseUpRectangleRegion(canvas.getSpread(),adjustRect(start.getX(), start.getY()));
			reg.setTemporary(this.isTemporary());
			canvas.addRegion(reg);
			
			UniSelectedState.getInstance().changeSelectedRegions(reg);
			
			new CloseUpViewerAction(reg);
		}
		
		this.start = null;
		this.end = null;
		/*
		 * J[\rectangle猳̏Ԃɖ߂Ă
		 * 
		 */
		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
		new ImageToolBarSetModeByMouseEvent().setMode(e,ImageToolBar.modeNone);
		setCursor(canvas);
	}
	@Override
	public void paint(Graphics g,SpreadCanvas canvas) {
		if (out) return;
		super.paint(g,canvas);
		if(this.start ==null || this.end == null){
			return;
		}
		double ratio = canvas.getImageLabel().getRatio();
		double gapX = canvas.getImageLabel().getGapWidth();
		double gapY = canvas.getImageLabel().getGapHeight();
		View view = new CloseUpRectangleView(adjustRect(start.getX(), start.getY())).enlargedView(ratio, gapX, gapY);
		
		view.draw((Graphics2D)g);
	}
	
	protected Rectangle2D adjustRect(double sx, double sy){
				double width, height;
		double startX, startY;
		
		if(start.getX() > end.getX()){
			startX = end.getX();
			width = start.getX() - end.getX();
		}
		else{
			startX = start.getX();
			width = end.getX() - start.getX();
		}
		if(start.getY() > end.getY()){
			startY = end.getY();
			height = start.getY() - end.getY();
		}
		else{
			startY = start.getY();
			height= end.getY() - start.getY();
		}
		return new Rectangle2D.Double(startX,startY,width,height);
	}
	@Override
	public boolean addingMarkup() {
		return true;
	}

}
