//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.webLoader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

    /**
     * 複数URLの取得結果を格納するクラス
     */

   public class MultiWebGetResults implements Iterable <WebGetResult> ,Serializable
    {
        private List<WebGetResult> resultElements;

        // コンストラクタ

        /**
         * コンストラクタ
         * @param results WebGetResult型の配列
         */
        public MultiWebGetResults(WebGetResult[] results)
        {
            resultElements = new ArrayList<WebGetResult>();
            int count = results.length;
            for (int i = 0; i < count; i++)
            {
                if (results[i] != null)
                {
                    resultElements.add(results[i]);
                }
            }

        }



        // 拡張子変更
        /**
         * ファイルの拡張子を変更する
         */
        public void changeExtension()
        {
            for (WebGetResult re: resultElements)
            {
                re.changeExtension();
            }
        }


        // ファイル削除

        /**
         * 一時ファイルをすべて削除する
         */
        public void deleteAll()
        {
            for (WebGetResult re: resultElements)
            {
                re.deleteFile();
            }
        }



        // プロパティ

        /**
         * URLの内容取得結果の配列
         */
        public WebGetResult[] getResultElements()
        {
        	return this.resultElements.toArray(new WebGetResult[0]);
        }

        /**
         * 取得したURLの個数
         */
        public int getCount()
        {
        	return this.resultElements.size();
        }



        // インデクサ

        /**
         * インデクサ
         * @param index インデックス
         * @return WebGetResult型
         */
        public WebGetResult get(int index)
        {
                return this.resultElements.get(index);
        }

//        //#endregion
//
//        //#region IEnumerable<WebGetResult> メンバ
//
//        IEnumerator<WebGetResult> IEnumerable<WebGetResult>.GetEnumerator()
//        {
//            return this.resultElements.GetEnumerator();
//        }
//
//        //#endregion
//
//        //#region IEnumerable メンバ
//
//        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
//        {
//            return this.resultElements.GetEnumerator();
//        }
//
//        //#endregion
//
//
//        //#region ISerializable メンバ
//
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("resultElements", this.resultElements);
//        }
//
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected MultiWebGetResults(SerializationInfo info, StreamingContext context)
//        {
//            this.resultElements = (List<WebGetResult>)info.GetValue("resultElements", typeof(List<WebGetResult>));
//        }

		public Iterator<WebGetResult> iterator() {
			return resultElements.iterator();
		}


    }

