package slothLib.web.search;

import slothLib.SlothLibException;
public class WebSearchException extends SlothLibException {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private HttpCode httpCode;

	public WebSearchException() {
	}
	
	public WebSearchException(String str) {
		super(str);
	}

	public WebSearchException(Throwable cause){
		super(cause);
	}
	public WebSearchException(String msg, Throwable cause){
		super(msg, cause);
	}
	
	public WebSearchException(String msg, HttpCode httpCode){
		super(msg);
		this.httpCode = httpCode;
	}

	public WebSearchException(HttpCode httpCode, String msg){
		super(msg);
		this.httpCode = httpCode;
	}
	
	public HttpCode getCode()
	{
		return this.httpCode;
	}

	
	/**
	 * HTTP Status Code
	 */
	public enum HttpCode
	{
		Unknown(-1),
		
		/**
		 * 400 Bad Request 不正なリクエスト
		 */
		BadRequest(400),
		
		/**
		 * 403 Forbidden アクセス拒否
		 */
		Forbidden(403),
		
		/**
		 * 503 Service Unavailable サービス利用不可
		 */
		ServiceUnavailable(503);

		private int val; 
		HttpCode(int val)
		{
			this.val = val;
		}
		int getVal()
		{
			return val;
		}
	}
	
}
