//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;

    /**
     * YouTube検索の結果を格納するクラス
     */
    public class YouTubeSearchResult implements IVideoSearchResult, Serializable
    {

        // privateフィールド

        private String query;
        private YouTubeElement[] resultElements;
        long totalNumber;



        // コンストラクタ

        /**
         * コンストラクタ
         * @param query 検索クエリ
         * @param totalNumber 総検索結果件数
         * @param resultElements 検索結果
         */
        public YouTubeSearchResult(String query, long totalNumber,YouTubeElement[] resultElements)
        {
            this.query = query;
            this.totalNumber = totalNumber;
            this.resultElements = resultElements;
        }



        // プロパティ

        /**
         * 検索クエリ
         */
        public String getQuery()
        {
        	return this.query;
        }

        /**
         * 検索結果要素配列
         */
        public YouTubeElement[] getResultElements()
        {
        	return this.resultElements;
        }

        /**
         * 総検索結果件数
         */
        public long getTotalNumber()
        {
        	return this.totalNumber;
        }




//        //#region IVideoSearchResult メンバ
//
//        IVideoElement[] IVideoSearchResult.ResultElements
//        {
//            get
//            {
//                return this.resultElements;
//            }
//        }
//
//        //#endregion
//
//        //#region ISearchResult メンバ
//
//        ISearchResultElement[] ISearchResult.ResultElements
//        {
//            get
//            {
//                return this.resultElements;
//            }
//        }
//
//        String ISearchResult.Query
//        {
//            get
//            {
//                return this.query;
//
//            }
//        }
//
//        long ISearchResult.TotalNumber
//        {
//            get
//            {
//                return this.totalNumber;
//            }
//        }




//        //#region ISerializable メンバ
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("query", this.query);
//            info.AddValue("resultElements", this.resultElements);
//            info.AddValue("totalNumber", this.totalNumber);
//        }
//
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected YouTubeSearchResult(SerializationInfo info, StreamingContext context)
//        {
//            this.query = info.GetString("query");
//            this.resultElements = (YouTubeElement[])info.GetValue("resultElements", typeof(YouTubeElement[]));
//            this.totalNumber = info.GetInt64("totalNumber");
//        }
//
//        //#endregion
    }

