//﻿using System;
//using System.Collections.Generic;
//using System.Text;

//using System.Xml;
//using System.Net;
//using System.IO;
//using System.Web;

package slothLib.web.search;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import slothLib.portUtil.PortUtil;

    /**
     * 教えて！Goo検索を行う
     * <remarks>
     * 

     * <newpara>[2007-06-12][inagawa]作成</newpara>
     * </remarks>
     */
    public class OshieteGooSearch implements ISearch
    {
        // コンストラクタ
        /**
         * コンストラクタ
         */
        public OshieteGooSearch() { }


        // private フィールド

        // proxy
        private Proxy proxy;



        // Proxy設定

        /**
         * プロクシを設定する。
         * @param proxyAddress 
         */
        public void setProxy(String proxyAddress)
        {
            if (proxyAddress == null)
            {
                this.proxy = null;
            }
            else
            {
                this.proxy = PortUtil.createProxy(proxyAddress);
            }
        }



        // DoSearch

        /**
         * 教えて！Goo検索を行う
         * @param query クエリ
         * @param maxNumber 最大結果数
         * @return 
         */
        public OshieteGooSearchResult doSearch(String query, int maxNumber)
        {
            return doOshieteSearch(query, maxNumber);
        }



        // 実働メソッド

        private OshieteGooSearchResult doOshieteSearch(String query, int maxNumber)
        {
            List<OshieteGooElement> elements = new ArrayList<OshieteGooElement>();
            long searchTotalResults = 0;
            int rank = 0;

            for (int page = 1; ; page++)
            {
            	String requestURL = makeRequestURL(query, maxNumber, page);
            	
            	Document xmlDoc;
				try {
					xmlDoc = PortUtil.getDocumentFromURL(requestURL, proxy);
				} catch (WebSearchException e) {
					e.printStackTrace();
					return null;
				}

                // ルートの要素を取得
                Element xmlRoot = xmlDoc.getDocumentElement();
                searchTotalResults = Long.parseLong(getElementString(xmlRoot.getElementsByTagName("oshietegoo:searchTotalResults")));

                NodeList xmlItemList = xmlRoot.getElementsByTagName("item");
                for (int i = 0; i < xmlItemList.getLength(); i++) 
                {
                	Element xmlItem = (Element)xmlItemList.item(i);
                	rank++;
                    String title = getElementString(xmlItem.getElementsByTagName("title"));
                    String url = getElementString(xmlItem.getElementsByTagName("link"));
                    String description = getElementString(xmlItem.getElementsByTagName("description"));
                    String category = getElementString(xmlItem.getElementsByTagName("dc:subject"));
                    String pubData = getElementString(xmlItem.getElementsByTagName("dc:date"));
                    String creater = getElementString(xmlItem.getElementsByTagName("dc:creator"));

                    OshieteGooElement element = new OshieteGooElement(url, title, description, pubData, category, creater, rank);
                    elements.add(element);

                    if (elements.size() >= maxNumber || elements.size() >= searchTotalResults)
                    {
                        int resultNum = elements.size();
                        return new OshieteGooSearchResult(query, searchTotalResults, elements.toArray(new OshieteGooElement[0]));
                    }
                }
            }//forループの終わり
        }



        // 雑用メソッド

        private String makeRequestURL(String query, int maxNumber, int page)
        {
            StringBuffer builder = new StringBuffer();
            builder.append("http://oshiete.goo.ne.jp/search/search.php?status=select&mt_opt=a&rss=1&MT=");
            //builder.append(HttpUtility.UrlEncode(query, Encoding.GetEncoding("euc-jp")));
            try {
            	builder.append(URLEncoder.encode(query, "EUC-JP"));
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
				builder.append(URLEncoder.encode(query));
			}
            //builder.append(query);
            builder.append("&dc=");
            builder.append(Math.min(maxNumber, 50));
            builder.append("&pg=");
            builder.append(page);

            return builder.toString();

            //Uri uri = new Uri(builder.toString());
            //return uri.AbsoluteUri;
        }

        /**
         * XmlNodeListの初めのノードのテキストを取得する
         * @param nodeList XmlNodeList
         * <returns>XmlNodeListの初めのノードのInnerText
         *          XmlNodeListが空であれば空文字列を返す</returns>
         */
        private String getElementString(NodeList nodeList)
        {
            if (nodeList.getLength() == 0)
            {
                return "";
            }
            else
            {
                return nodeList.item(0).getTextContent();
            }
        }




//        //#region ISearch メンバ
//
//        ISearchResult ISearch.DoSearch(String query, int resultNum)
//        {
//            return this.DoSearch(query,resultNum);
//        }
//
//        //#endregion
    }

