//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Xml;
//using System.IO;
//using System.Web;
//using System.Net;

package slothLib.web.search;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import slothLib.portUtil.PortUtil;

    /**
     * GooBlog検索を実行するクラス
     */
    public class GooBlogSearch implements IBlogSearch
    {

        // privateフィールド

        private SortType sortType;
        private Proxy proxy;
        


        // コンストラクタ

        /**
         * コンストラクタ
         */
        public GooBlogSearch()
        {
            this.proxy = null;
            this.sortType = SortType.Score;
        }



        // DoSearch
        
        /**
         * GooBlog検索を実行する
         * @param query 検索クエリ
         * @param resultNum 検索結果取得数
         * @return GooBlogSearchResult型の検索結果
         */
        public GooBlogSearchResult doSearch(String query, int resultNum)
        {
            return DoGooBlogSearchOver(query, resultNum);
        }

//        //#region IBlogSearch メンバ
//
//        /// <summary>
//        /// GooBlog検索を実行する
//        /// </summary>
//        /// <param name="query">検索クエリ</param>
//        /// <param name="resultNum">検索結果取得数</param>
//        /// <returns>GooBlogSearchResult型の検索結果</returns>
//        IBlogSearchResult IBlogSearch.DoSearch(String query, int resultNum)
//        {
//            return DoSearch(query, resultNum);
//        }
//
//        //#endregion
//
//        //#region ISearch メンバ
//
//        /// <summary>
//        /// GooBlog検索を実行する
//        /// </summary>
//        /// <param name="query">検索クエリ</param>
//        /// <param name="resultNum">検索結果取得数</param>
//        /// <returns>GooBlogSearchResult型の検索結果</returns>
//        ISearchResult ISearch.DoSearch(String query, int resultNum)
//        {
//            return DoSearch(query, resultNum);
//        }





        // privateメソッド

        private GooBlogSearchResult doGooBlogSearch(String query, int start, int resultNum, int tureResultNum)
        {
            String requestURL = makeRequestURL(query, start, resultNum);
            System.err.println("start! "  + requestURL);

            
            Document xmlDoc;
			try {
				xmlDoc = PortUtil.getDocumentFromURL(requestURL, this.proxy);
			} catch (WebSearchException e) {
				e.printStackTrace();
				return null;
			}
            
            List<GooBlogElement> resultElementList = new ArrayList<GooBlogElement>();

            // ルートの要素を取得
            Element xmlRoot = xmlDoc.getDocumentElement();


            //検索総件数
            NodeList nodeList = xmlRoot.getElementsByTagName("channel");
            if (nodeList == null)
            {
                return new GooBlogSearchResult(query, 0, resultElementList.toArray(new GooBlogElement[0]));
            }

      
            
            String strTotalNumber = getElementString(((Element)nodeList.item(0)).getElementsByTagName("gooblog:searchTotalResults"));
            long totalSearchResults;
            if (PortUtil.isNullOrEmpty(strTotalNumber))
            {
                totalSearchResults = 0;
            }
            else
            {
                totalSearchResults = Long.parseLong(strTotalNumber.replace(",",""));
            }

            NodeList items = xmlRoot.getElementsByTagName("item");

            int count = 0;
            for (int i = 0; i < items.getLength(); i++)
            {
            	Element element = (Element) items.item(i);
            	String title = getElementString(element.getElementsByTagName("title"));
                String link = getElementString(element.getElementsByTagName("link"));
                String description = getElementString(element.getElementsByTagName("description"));
                Date date = parseGooDate(getElementString(element.getElementsByTagName("dc:date")));
                String source = getElementString(element.getElementsByTagName("ag:source"));
                String sourceURL = getElementString(element.getElementsByTagName("ag:sourceURL"));
                GooBlogElement gooElement = new GooBlogElement(title, link, description, date, source, sourceURL);
                resultElementList.add(gooElement);
                count++;
                if (count >= tureResultNum)
                {
                    break;
                }
            }
            System.err.println("finish! " + requestURL);
            return new GooBlogSearchResult(query, totalSearchResults, resultElementList.toArray(new GooBlogElement[0]));
            
            
        }

        private GooBlogSearchResult DoGooBlogSearchOver(String query, int resultNum)
        {
            int unit;
            //めんどくさいから50件未満は10件単位で．
            if (resultNum < 50)
            {
                unit = 10;
            }
            //めんどくさいから50件以上は50件単位で
            else
            {
                unit = 50;
            }

            // 結果統合用
            List<GooBlogElement> ResultElementList = new ArrayList<GooBlogElement>();


            int loop = (resultNum - 1) / unit;
            // 結果をunitずつに分けて取得
            for (int i = 0; i< loop; i++)
            {
                GooBlogSearchResult r = doGooBlogSearch(query, 1 + i * unit, unit,unit);
                ResultElementList.addAll(Arrays.asList(r.getResultElements()));
            }
            GooBlogSearchResult gsr = doGooBlogSearch(query, loop * unit + 1, unit, resultNum - loop * unit);
            ResultElementList.addAll(Arrays.asList(gsr.getResultElements()));

            // 返す結果を作成してさようなら。
            return new GooBlogSearchResult(query, gsr.getSearchTotalResults(), ResultElementList.toArray(new GooBlogElement[0]));
        }



        // 雑用メソッド
        /**
         * XmlNodeListの初めのノードのテキストを取得する
         * @param nodeList XmlNodeList
         * <returns>XmlNodeListの初めのノードのInnerText
         *          XmlNodeListが空であれば空文字列を返す</returns>
         */
        private String getElementString(NodeList nodeList)
        {
            if (nodeList.getLength() == 0)
            {
                return "";
            }
            else
            {
                return nodeList.item(0).getTextContent();
            }
        }


        private String makeRequestURL(String query, int start, int resultNum)
        {
            String encodedQuery;
			try {
				encodedQuery = java.net.URLEncoder.encode(query, "EUC-JP"); 
			} catch (UnsupportedEncodingException e) {
				// use default encode
				e.printStackTrace();
				encodedQuery = java.net.URLEncoder.encode(query); 
			}
			String url = "http://blog.search.goo.ne.jp/search_goo/result/?tg=all&da=all&st=score&dp=all&bu=&ts=all&status=select" 
				+ "&MT=" 
//        	+ System.Web.HttpUtility.UrlEncode(query, System.Text.Encoding.GetEncoding("euc-jp")) 
				+ encodedQuery 
				+ "&dc=" + resultNum + "&fr=" + start
			    + "&rss=1";

			switch (this.sortType)
            {
                case Date:
                    url += "&st=date";
                    break;
                case Score:
                    url += "&st=score";
                    break;
            }
            return url;
        }

        /**
         * GooBlog検索の更新日時の文字列をDateTime型に変換
         * @param strDate 
         * @return 
         */
        private Date parseGooDate(String strDate)
        {
            if (PortUtil.isNullOrEmpty(strDate))
            {
                return new Date();
            }

            try
            {
            	return (new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzz")).parse(strDate);
            }
            catch (ParseException e)
            {
                return new Date();
            }
        }



        // プロパティ

        /**
         * プロクシを取得・設定する。
         */
        public Proxy getProxy()
        {
        	return this.proxy;
        }
        public void setProxy(Proxy value)
        {
        	this.proxy = value;
        }

        /**
         * ソート方法を取得・設定する
         */
        public SortType getSortBy()
        {
        	return this.sortType;
        }
        public void setSortBy(SortType value)
        {
        	this.sortType = value;
    
        }




        // 列挙型

        /**
         * ソート方法
         */
        public enum SortType
        {
            /**
             * 適合度順
             */
            Score,
            /**
             * 更新日順
             */
            Date,
        }


    }

