//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;
import java.util.Date;


    /**
     * GooBlog検索結果の要素を格納する
     * 

     */

    public class GooBlogElement implements IBlogElement,Serializable
    {

        // privateフィールド

        private String title;
        private String link;
        private String description;
        private Date date;
        private String source;
        private String sourceURL;



        // コンストラクタ

        /**
         * コンストラクタ
         * @param title ブログ記事のタイトル
         * @param link ブログ記事へのURL
         * @param description ブログ記事の冒頭
         * @param date ブログの記入日時
         * @param source ブログのタイトル
         * @param sourceURL ブログのURL
         */
        public GooBlogElement(String title, String link, String description, Date date, String source, String sourceURL)
        {
            this.title = title;
            this.link = link;
            this.description = description;
            this.date = date;
            this.source = source;
            this.sourceURL = sourceURL;
        }



        // プロパティ

        /**
         * ブログ記事のタイトル
         */
        public String getTitle()
        {
        	return this.title;
        }

        /**
         * ブログ記事へのURL
         */
        public String getLink()
        {
        	return this.link;
        }

        /**
         * ブログ記事の冒頭
         */
        public String getDescription()
        {
        	return this.description;
        }

        /**
         * ブログ記事の記入日時
         */
        public Date getDate()
        {
        	return this.date;
        }

        /**
         * ブログのタイトル
         */
        public String getSource()
        {
        	return this.source;
        }

        /**
         * ブログのURL
         */
        public String getSourceURL()
        {
        	return this.sourceURL;
        }
        




//        //#region IBlogElement メンバ
//
//        /// <summary>
//        /// ブログ記事の記入日時
//        /// </summary>
//        Date IBlogElement.Date
//        {
//            get
//            {
//                return this.date;
//            }
//        }
//
//        //#endregion
//
//        //#region ISearchResultElement メンバ
//
        /**
         * ブログ記事へのURL
         */
        public String getURL()
        {
        	return this.link;
        }
//
//        /// <summary>
//        /// ブログ記事のタイトル
//        /// </summary>
//        String ISearchResultElement.Title
//        {
//            get
//            {
//                return this.title;
//            }
//        }
//
//        /// <summary>
//        /// ブログ記事の冒頭
//        /// </summary>
//        String ISearchResultElement.Description
//        {
//            get
//            {
//                return this.description;
//            }
//        }
//
//        //#endregion

//        //#region ISerializable メンバ
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("title", this.title);
//            info.AddValue("link", this.link);
//            info.AddValue("description", this.description);
//            info.AddValue("date", this.date);
//            info.AddValue("source", this.source);
//            info.AddValue("sourceURL", this.sourceURL);
//        }
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected GooBlogElement(SerializationInfo info, StreamingContext context)
//		{
//			this.title = info.GetString("title");
//			this.link = info.GetString("link");
//			this.description = info.GetString("description");
//			this.date = info.GetDate("date");
//            this.source = info.GetString("source");
//            this.sourceURL = info.GetString("sourceURL");
//		}
//        //#endregion
    }
