//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;
    /**
     * LiveWebSearchの検索結果の要素を格納する
     */
    public class LiveWebElement implements IWebElement, Serializable
    {
        // private フィールド

        private String title;
        private String description;
        private String url;
        private String displayURL;
        private String cacheURL;
        private String searchTags;



        // コンストラクタ

        /**
         * コンストラクタ
         * @param title ページのタイトル
         * @param description ページの要約
         * @param url ページのURL
         * @param displayURL 検索結果表示用のURL
         * @param cacheURL キャッシュ先のURL
         * @param searchTags 検索結果に関連付けられたタグの一覧
         */
        public LiveWebElement(String title, String description, String url, String displayURL, String cacheURL, String searchTags)
        {
            this.title = title;
            this.description = description;
            this.url = url;
            this.displayURL = displayURL;
            this.cacheURL = cacheURL;
            this.searchTags = searchTags;
        }



        // プロパティ

        /**
         * ページのタイトル
         */
        public String getTitle()
        {
                return this.title;
        }

        /**
         * ページのURL
         */
        public String getURL()
        {
        	return this.url;
        }

        /**
         * ページの要約
         */
        public String getDescription()
        {
        	return this.description;
        }

        /**
         * 検索結果表示用のURL
         */
        public String getDisplayURL()
        {
        	return this.displayURL;
        }

        /**
         * キャッシュ先のURL
         */
        public String getCacheURL()
        {
        	return this.cacheURL;
        }

        /**
         * 検索結果に関連付けられたタグの一覧
         */
        public String getSearchTags()
        {
        	return this.searchTags;
        }



//        //#region ISearchResultElement メンバ
//
//        /// <summary>
//        /// ページのURL
//        /// </summary>
//        String ISearchResultElement.URL
//        {
//            get { return this.url;
//            }
//        }
//
//        /// <summary>
//        /// ページのタイトル
//        /// </summary>
//        String ISearchResultElement.Title
//        {
//            get
//            {
//                return this.title;
//            }
//        }
//
//        /// <summary>
//        /// ページの要約
//        /// </summary>
//        String ISearchResultElement.Description
//        {
//            get
//            {
//                return this.description;
//            }
//        }
//
//        //#endregion

//        //#region ISerializable メンバ
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//		{
//			info.AddValue("title", this.title);
//			info.AddValue("description", this.description);
//			info.AddValue("url", this.url);
//			info.AddValue("displayURL", this.displayURL);
//			info.AddValue("cacheURL", this.cacheURL);
//			info.AddValue("searchTags", this.searchTags);
//		}
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected LiveWebElement(SerializationInfo info, StreamingContext context)
//		{
//			this.title = info.GetString("title");
//            this.description = info.GetString("description");
//			this.url = info.GetString("url");
//            this.displayURL = info.GetString("displayURL ");
//            this.cacheURL = info.GetString("cacheURL");
//            this.searchTags = info.GetString("searchTags");
//		}
//
//        //#endregion
    }

