//﻿using System;
//using System.Collections.Generic;
//using System.Text;
//using SlothLib.Web.Search;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;

/**
 * Flickr検索結果の要素を格納する
 */

public class FlickrElement implements IImageElement,Serializable 
{
	
	/**
	 * <param name="id">画像のID</param>
	 * <param name="owner">所有者のID</param>
	 * <param name="secret">Secret</param>
	 * <param name="server">Server</param>
	 * <param name="farm">Farm</param>
	 * <param name="title">画像のタイトル</param>
	 * <param name="isPublic">画像が公開されているかどうか</param>
	 * <param name="isFriend">画像の所有者の友達であるかどうか</param>
	 * <param name="isFamily">画像の所有者の家族であるかどうか</param>
	 */
	
	public FlickrElement(String id, String owner, String secret, String server, String farm, String title,
			boolean isPublic, boolean isFriend, boolean isFamily)
	{
		this.id = id;
		this.owner = owner; 
		this.secret = secret; 
		this.server = server;
		this.farm = farm; 
		this.title = title;
		this.isPublic = isPublic; 
		this.isFriend = isFriend; 
            this.isFamily = isFamily;
        }

	
	// privateフィールド
	
	private String id;
	private String owner;
	private String secret;
	private String server;
	private String farm;
	private String title;
	private boolean isPublic;
	private boolean isFriend;
	private boolean isFamily;
	
	
	// プロパティ

	/**
	 *画像のID
	 */
	public String getID()
	{
		return this.id;
	}
	
	/**
	 * タイトル
	 */
	public String getTitle()
	{
		return this.title;
	}
	
	/**
	 * 画像の所有者
	 */
	public String getOwner()
	{
		return this.owner;
	}
	
	/**
	 * 画像が公開されているかどうか
	 */
	public boolean getIsPublic()
	{
		return this.isPublic;
	}
	
	/**
	 * 画像の所有者の友達であるかどうか
	 */
	public boolean getIsFriend()
	{
		return this.isFriend;
	}
	
	/**
	 * 画像の所有者の家族であるかどうか
	 */
	public boolean getIsFamily()
	{
		return this.isFamily;
	}
	
	
	/**
	 * URL
	 */
	public String getURL()
	{
		String url = "http://farm" + farm + ".static.flickr.com/" + server + "/" + id + "_" + secret + ".jpg";
		return url;
	}
	

	
	/**
	 * toStringのオーバーライド
	 * <returns>Flickr検索結果要素の内容</returns>
	 */
	public String toString()
	{
		return "Title: " + title + "\r\n"
		+ "URL: " + "http://farm" + farm + ".static.flickr.com/" + server + "/" + id + "_" + secret + ".jpg";
	}
	

	
	// ISearchResultElement メンバ
	
	/**
	 * ページのURL
	 */
//	String ISearchResultElement.URL
//	{
//	get {
//	String url = @"http://farm" + farm + @".static.flickr.com/" + server + @"/" + id + @"_" + secret + @".jpg";
//	return url; 
//	}
//	}
	
	/**
	 * ページのタイトル
	 */
//	String ISearchResultElement.Title
//	{
//	get { return this.Title; }
//	}
	
	/**
	 * ページの要約(未実装)
	 * 現在はTitleと同じ値を出力
	 */
	public String getDescription()
	{
		return this.title;
	}
	

	
//	//#region ISerializable メンバ
//	
//	/// <summary>
//	/// シリアライズ化するときに呼び出される関数
//	/// </summary>
//	/// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//	/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//	void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//	{
//	info.AddValue("id", this.id);
//	info.AddValue("owner", this.owner);
//	info.AddValue("secret", this.secret);
//	info.AddValue("server", this.server);
//	info.AddValue("farm", this.farm);
//	info.AddValue("title", this.title);
//            info.AddValue("isPublic", this.isPublic);
//            info.AddValue("isFriend", this.isFriend);
//            info.AddValue("isFamily", this.isFamily);
//		}
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//		protected FlickrElement(SerializationInfo info, StreamingContext context)
//		{
//            this.id = info.GetString("id");
//            this.owner = info.GetString("owner");
//            this.secret = info.GetString("secret");
//            this.server = info.GetString("server");
//            this.farm = info.GetString("farm");
//            this.title = info.GetString("title");
//            this.isPublic = info.GetBoolean("isPublic");
//            this.isFriend = info.GetBoolean("isFriend");
//            this.isFamily = info.GetBoolean("isFamily");
//		}
//
//
//		//#endregion

}

