package slothLib.test;

import slothLib.SlothLibException;
import slothLib.NLP.IMorpheme;
import slothLib.NLP.IMorphemeFilter;
import slothLib.NLP.MeCabResult;
import slothLib.NLP.MeCabServer;
import slothLib.NLP.PosFilter;

public class PosFilterTest {

	/**
	 * @param args
	 */
	
	public static void main(String[] args) throws SlothLibException {
		String tmp = "Javaでは ISearch.DoSearch や IWebSearch.DoSearchを実装しなくてもよいようです．\n" +
		"まあ，実装することが言語機能的に出来ないのですが．\n" +
		"また，Javaではシリアライズはデフォルトでやってくれるので楽です．\n";
		
		MeCabServer mecab = new MeCabServer();
		MeCabResult result = mecab.doAnalyze(tmp);
		//System.out.println(result.getRawResult());

		IMorphemeFilter filter =  new PosFilter("名詞|動詞");
		for (IMorpheme s: filter.doFilter(result.getMorphemes()))
			System.out.println(s);
		
		
	}

}
