package slothLib.portUtil;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ProcessPipe {
	List <ProcessBuilder> pbs = new ArrayList<ProcessBuilder>(); 
	List <Process> procs = new ArrayList<Process>();
	
	public void add(ProcessBuilder pb){
		pbs.add(pb);
	}

	public void add(String [] cmd){
		pbs.add(new ProcessBuilder(cmd));
	}
	
	private InputStream is = null;
	private InputStream error = null;
	
	public void start(String filename) throws IOException {
		Vector <InputStream> errors = new Vector<InputStream>();
		
		if (filename != null)
			is = new FileInputStream(filename);
		for (ProcessBuilder pb: pbs) {
			Process p = pb.start();
			if (is != null) 
				Redirector.redirect(is, p.getOutputStream());
			is = p.getInputStream();
			procs.add(p);
			errors.add(p.getErrorStream());
		}
		error = new SequenceInputStream(errors.elements());
	}
	
	public void start() throws IOException{
		start(null);
	}

	int val = 0;
	public int exitValue() {
		try {
			waitFor();
		} catch (InterruptedException e) {
		}
		return val;
	}
	
	public void waitFor() throws InterruptedException{
		for (Process p: procs) {
			p.waitFor();
			if (p.exitValue() != 0)
				val = p.exitValue();
		}
	}

	String file; 
	public void setResultFileName(String file){
		this.file = file;
	}
	
	public InputStream getInputStream() throws IOException{
		if (file != null)
			return new FileInputStream(file);
		return is;
	}

	public InputStream getErrorStream(){
		return error;
	}
	
	public void destroy(){
		for (Process p: procs)
			p.destroy();
	}
	
	
}
;