package slothLib.linearAlgebra.matrix;

/**
 * 行列の減算
 * Value = Value1 - Value2;
 */

public class SubtractMatrix extends BasicMatrix {
    /**
	 * コンストラクタ
	 * @param matrix1 引かれる行列
	 * @param matrix2 引く行列
     */
	public SubtractMatrix(IMatrix matrix1, IMatrix matrix2)
	{
    	super(matrix1.rowCount(), matrix1.columnCount());
		if ((matrix1.rowCount() != matrix2.rowCount()) || (matrix1.columnCount() != matrix2.columnCount()))
        {
            // 現時点ではエラーを投げて終了
            throw new IllegalArgumentException("左行列と右行列とで行数及び列数が一致しません");
        }

        calculate(matrix1, matrix2);
    }


    private void calculate(IMatrix matrix1, IMatrix matrix2)
    {
        for (int i = 0; i < this.rowCount(); i++)
        {
            for (int j = 0; j < this.columnCount(); j++)
            {
            	set(i, j, matrix1.get(j, i) - matrix2.get(j, i) );
            }
        }
    }

}
