package slothLib.linearAlgebra.matrix;

/**
 * 最大の要素が1になるように正規化
 * Value = Value / Max
 */

public class MaxNormMatrix extends BasicMatrix {

	public MaxNormMatrix(IMatrix matrix)
    {
        super(matrix.rowCount(), matrix.columnCount());
    	double absMax = MatrixOperator.getMaxNorm(matrix);

    	for (int i = 0; i < matrix.rowCount(); i++)
        {
        	for (int j = 0; j < matrix.columnCount(); j++)
            {
                if (absMax != 0.0)
                {
                	set(i, j, matrix.get(i, j) /absMax);
                }
                else
                {
                	set(i, j, 0.0); //was default(double);
                }

                
            }
        }
    }

}
