package slothLib.linearAlgebra.matrix;


/**
 * 対数
 * Value = Log(Value + addValue)
 * ただし、元のValueが0以上の時のみ上記の値が計算される
 */
public class LogMatrix extends BasicMatrix {
	/**
	 * コンストラクタ
     * baseValue = 2.0;
     * addValue = 1.0;
	 * @param matrix 
	 */
    public LogMatrix(IMatrix matrix){
    	this(matrix, 2.0, 1.0);
    }
    
    /**
     * コンストラクタ
     * @param matrix 
     * @param baseValue logの底
     * @param addValue logする前に加算する値
     */

    public LogMatrix(IMatrix matrix, double baseValue, double addValue)
    {
        super(matrix.rowCount(), matrix.columnCount());

        for (int i = 0; i < matrix.rowCount(); i++)
        {
            for (int j = 0; j < matrix.columnCount(); j++)
            {

                if (matrix.get(i, j) <= 0.0)
                {
                	set(i, j, Math.log(addValue + matrix.get(i, j)) / Math.log(baseValue));
                }
                else
                {
                	set(i, j, Math.log(matrix.get(i, j)) / Math.log(baseValue));

                }

            }
        }
    }

}
