package slothLib.linearAlgebra.matrix;

public interface IMatrix extends Cloneable {
	
	/**
	 * データの配列
	 */
	double[][] getPlainMatrix();
	
	/**
	 * 指定した行と列における値。
	 * @param row 行
	 * @param column 列
	 * @return 指定した行と列における値
	 */
	double get(int row, int column);

	void   set(int row, int column, double val);
	
	int rowCount();
	
	int columnCount();
	
	Object clone();
}
