package slothLib.linearAlgebra.matrix;
import slothLib.linearAlgebra.vector.*;

public class BasicMatrix {
	/**
	 * 行列の本体である配列
	 */
	private double[][] matrix;

    /**
	 * コンストラクタ．
	 * @param row 行数
	 * @param column 列数
     */
	public BasicMatrix(int row, int column)
	{
		this.matrix = new double[row][column];
	}

	/**
	 * コンストラクタ．
     * matrixをもとに行列を作成する．
	 * @param matrix 
	 */
	public BasicMatrix(double[][] matrix){
		this(matrix.length, matrix[0].length);

		for (int r = 0; r < matrix.length; r++)
		{
			for (int c = 0; c < matrix[0].length; c++)
			{
				this.matrix[r][c] = matrix[r][c];
			}
		}
	}

	/**
	 * コンストラクタ．
     * matrixをもとに行列を作成する．
	 * @param matrix 
	 */
	public BasicMatrix(IMatrix matrix){
		this(matrix.rowCount(), matrix.columnCount());
		for (int r = 0; r < matrix.rowCount(); r++)
		{
			for (int c = 0; c < matrix.columnCount(); c++)
			{
				this.matrix[r][c] = matrix.get(r, c);
			}
		}
	}


	/**
	 * コンストラクタ。
	 * ベクトル集合から、1ベクトルを行とする行列を作成する。
	 * @param vectorCollection 
	 */
	public BasicMatrix(VectorCollection vectorCollection){
		this(vectorCollection.count(), vectorCollection.dimension());
		for (int r = 0; r < vectorCollection.count(); r++)
		{
			for (int c = 0; c < vectorCollection.dimension(); c++)
			{
				this.matrix[r][c] = vectorCollection.get(r).get(c);
			}
		}
    }

    /**
	 * データの配列のコピー
     */
	public double[][] getPlainMatrix()
	{
		return (double[][])this.matrix.clone();
	}

	/**
	 * 行列にアクセスする
	 * @param row 行
	 * @param column 列
	 * @return 指定した行と列における値
	 */
	public double get(int row, int column){
		if (this.isIndexInRange(row, column))
			return this.matrix[row][column];
		else
			return 0.0;
	}
	public void set(int row, int column, double value){
		if (this.isIndexInRange(row, column))
			this.matrix[row][column] = value;
	}

	/**
	 * 行数
	 */
	public int rowCount()
	{
		return this.matrix.length;
		
	}

	/**
	 * 列数
	 */
	public int columnCount()
	{
		return this.matrix[0].length;
	}

    /**
     * 行列の複製を取得する
     */
    public Object clone()
    {
        return new BasicMatrix(this.getPlainMatrix());
    }

    /**
     * 指定されたインデクスでこの行列にアクセスできるかどうか
     * @param row インデクスの行番号
     * @param column インデクスの列番号
     * @return アクセスできる場合はtrue，できない場合はfalse
     */
    public boolean isIndexInRange(int row, int column)
    {
        boolean result = true;

        result = result && (row < this.rowCount());
        result = result && (column < this.columnCount());

        return result;
    }

}
