package slothLib.linearAlgebra.featureVector;

import java.util.Comparator;

public class VectorComparer<T> implements Comparator<T> {
    private IVector<T> vector;
    private int sortOrder;
	
	public VectorComparer(IVector<T> vector) {
		this.vector = vector;
		this.sortOrder = -1;
	}

	public int compare(T x, T y) {
		double dx = this.vector.get(x);
		double dy = this.vector.get(y);
		int ret;
		if (dx == dy)
			ret = 0;
		else if (dx > dy)
			ret = 1;
		else
			ret = -1;
		
		return ret * this.sortOrder;
	}

}
