package slothLib.linearAlgebra.featureVector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class HierarchicalClusteringResult<T> {

	// デンドログラムのノード
	private IDendrogramNode<T>[] nodes;

	// クラスタリングされるベクトル群
	private IVector<T>[] vectors;

	// 距離か類似度か
	private ClusteringDistanceType dType;

	// 距離テーブルの計算器が距離ならば1、類似度ならば-1を保持する。
	private double ds;

	/**
	 * 総アイテム数
	 */
	private int itemCount;


	/**
	 * コンストラクタ
	 * @param nodes 
	 * @param vectors 
	 * @param dType 
	 */
	public HierarchicalClusteringResult(IDendrogramNode<T>[] nodes, IVector<T>[] vectors, ClusteringDistanceType dType)
	{
		this.nodes = nodes;
		this.vectors = vectors;
		this.itemCount = vectors.length;
		this.dType = dType;
		// 類似度の場合は、距離テーブルで-1を掛けた値を保持している
		this.ds = 1;
		if (dType == ClusteringDistanceType.Similarity)
		{
			this.ds = -1;
		}
	}

	/**
	 * 結果の節点を配列で返す。
	 * このときの配列の順番は、クラスタリングで先にくっついたやつの順。
	 */
	public IDendrogramNode<T>[] dendrogramNodes()
	{
		return this.nodes;
	}



	/**
	 * クラスタを取得する。
	 * @param thresholdClusterCount 
	 * @param thresholdDistanceOrSimilarity 
	 * @return 
	 */
	public ClusteringResult<T> getClusteringResult(int thresholdClusterCount, double thresholdDistanceOrSimilarity)
	{

		/*
		// クラスタリングのノードが少なくとも1つ以上あることを確認する
		if (this.nodes.Length < 1)
		{
			throw new Exception("クラスタリングの結果のノードが存在しません。");
		}
		 */

		// 距離または類似度の閾値
		double thresholdDs = thresholdDistanceOrSimilarity * this.ds;

		// アイテムの現在クラスタ番号
		int[] clusterID = new int[itemCount];
		// クラスタの重心ベクトル
		
		// new IVector<T>[] is impossible in java.
		IVector<T>[] centroidVectors = (IVector<T>[])new Object[itemCount];
		// 初期のクラスタ番号
		for (int i = 0; i < itemCount; i++)
		{
			clusterID[i] = i;
			centroidVectors[i] = vectors[i];
		}

		// クラスタの現在の個数
		int numCluster = itemCount;

		// デンドログラムを一個ずつ見ていく。
		for (IDendrogramNode<T> node: this.nodes)
		{
			// リミットに達していたら終了
			if (numCluster <= thresholdClusterCount || node.distance() > thresholdDs)
			{
				break;
			}

			// 後者のクラスタに属するアイテムのクラスタIDを前者のやつに書き換える。
			for (int i = node.itemID2(); i < itemCount; i++)
			{
				if (clusterID[i] == node.itemID2())
				{
					clusterID[i] = node.itemID1();
					centroidVectors[i] = node.centroidVector();
				}
			}

			// というわけで、クラスタの数が一つ少なくなりました。
			numCluster--;
		}

		// 結果の格納用。
		List<Cluster<T>> clusterList = new ArrayList<Cluster<T>>();

		// 現時点で処理済みのクラスタ個数。
		int curLoc = 0;
		// まわす
		for (int i = 0; i < itemCount; i++)
		{
			// クラスタの代表さん＝先頭さんを見つける。
			if (clusterID[i] == i)
			{
				// そのクラスタに属する奴らを格納する変数
				List<IVector<T>> members = new ArrayList<IVector<T>>();
				// そのクラスタに属する奴らのインデックスを格納する変数
				List<Integer> indices = new ArrayList<Integer>();
				// 先頭さんはまずはいるよね。
				members.add(this.vectors[i]);
				indices.add(i);
				for (int j = i + 1; j < itemCount; j++)
				{
					if (clusterID[j] == i)
					{
						members.add(this.vectors[j]);
						indices.add(j);
					}
				}
				int[] indicesArray = new int[indices.size()];
				for (int l_i = 0; l_i < indices.size(); l_i++)
					indicesArray[l_i] = indices.get(l_i);
				clusterList.add(new Cluster<T>((IVector<T>[])(members.toArray()), indicesArray, centroidVectors[i]));
				// 一つのクラスタの処理終了。
				curLoc++;
			}
		}

		// 結果を返します。
		return new ClusteringResult<T>((Cluster<T>[])clusterList.toArray());
	}


	/**
	 * クラスタを取得する。
	 * @param thresholdClusterCount 
	 * @return 
	 */
	public ClusteringResult<T> GetClusteringResult(int thresholdClusterCount)
	{
		return getClusteringResult(thresholdClusterCount, HierarchicalClusteringProcess.INFINITE_DISTANCE * this.ds);
	}


	/**
	 * クラスタを取得する。
	 * @param thresholdDistanceOrSimilarity 
	 * @return 
	 */
	public ClusteringResult<T> GetClusteringResult(double thresholdDistanceOrSimilarity)
	{
		return getClusteringResult(1, thresholdDistanceOrSimilarity);
	}




}
