package slothLib.linearAlgebra.featureVector;

/**
 * 最長距離法
 * <typeparam name="T"></typeparam>
 */
public class CompleteLinkageClusteringProcess<T> extends HierarchicalClusteringProcess<T>
{

	/**
	 * コンストラクタ
	 * @param vectors 
	 * @param calculator 
	 * @param dType 
	 */
	public CompleteLinkageClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType)
	{
		super(vectors, calculator, dType);
	}
	
	/**
	 * クラスタを結合する
	 * @param cid1 
	 * @param cid2 
	 */
	protected void union(int cid1, int cid2)
	{
		// クラスタ番号の更新
		clusterID[cid2] = cid1;

		// 距離テーブルの更新
		for (int i = 0; i < this.itemCount; i++)
		{
			// クラスタの代表ではなかったり、距離テーブルの対角成分は更新・参照の対象ではない。
			if (clusterID[i] != i || i == cid1 || i == cid2)
			{
				continue;
			}
			// この条件式がSingleLinkageであるゆえん。
			if (this.clusterID[i] == i && this.getDistance(cid1, i) < this.getDistance(cid2, i))
			{
				setDistance(cid1, i, getDistance(cid2, i));
			}
		}
	}

}
