package slothLib.linearAlgebra.featureVector;

/**
 * 最長距離法
 * <typeparam name="T"></typeparam>
 */
public class CompleteLinkageClustering<T> extends HierarchicalClustering<T>
{

	/**
	 * 距離を距離テーブル作成に用いる
	 * @param distanceCalculator 
	 */
	public CompleteLinkageClustering(IDistanceCalculator<T> distanceCalculator)
	{
		super(distanceCalculator);

	}

	/**
	 * 類似度を距離テーブル作成に用いる
	 * @param similarityCalculator 
	 */
	public CompleteLinkageClustering(ISimilarityCalculator<T> similarityCalculator)
	{
		super(similarityCalculator);
	}

	/**
	 * クラスタリングを実際に行うクラスを返す
	 * @param vectors 
	 * @return 
	 */
	protected IHierarchicalClusteringProcess<T> getProcess(IVector<T>[] vectors)
	{
		return new CompleteLinkageClusteringProcess<T>(vectors, this.calculator, this.dType);
	}

}
