package slothLib;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SlothLib {
	private static final String SLOTH_LIB_PROP_FILE = "slothlib.properties"; 
	static {
		Properties systemProp = System.getProperties();
			
		Properties prop = new Properties(systemProp);
		InputStream is = SlothLib.class.getClassLoader().getResourceAsStream(SLOTH_LIB_PROP_FILE);

		try {
			if (is != null) {  // the file is in the CLASSPATH 
				prop.load(is);
				System.setProperties(prop); // replace the system properties with new one.
			}
		} catch (IOException e) {
			e.printStackTrace();
		}		

	}

	public static void init(){
		// just to make sure that this class is loaded
	}


	static final  String DEFALT_ENCODING_KEY = "slothlib.default.encoding"; 
	static final  String DEFALT_ENCODING_DEFAULT = "UTF-8"; 
	
	public static String getDefaultEncoding() {
		return System.getProperty(DEFALT_ENCODING_KEY, DEFALT_ENCODING_DEFAULT);
	}
}
