package slothLib.NLP;

/// <summary>
/// 全ての文字を全角文字にするフィルタ。
/// 半角英数や記号も全角になるので注意
/// </summary>
/// <remarks>
/// 
/// <newpara>[2007-05-16][kabutoya]作成</newpara>
/// </remarks>
public class ToWideFilter extends AbstractStringFilter
{
	/// <summary>
	/// 全ての文字を全角文字にする。
	/// 半角英数や記号も全角になるので注意
	/// </summary>
	/// <param name="str">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列</returns>
	public String doFilter(String str)
	{
		return Filter.toWide(str);
	}
}
