package slothLib.NLP;

/**
	 * 茶筌の出力する形態素情報のクラス
	 * <remarks>
	 * 

	 * <newpara>[2007-04-21][ohshima]作成</newpara>
	 * </remarks>
 */
	public class ChaSenMorpheme extends Morpheme
	{
        /**
         * コンストラクタ
         * @param raw 出現形
         * @param reading 読み
         * @param original 原形
         * @param pos 品詞
         * @param conjugationPattern 活用型
         * @param conjugationForm 活用形
         */
		public ChaSenMorpheme(String raw, String reading, String original, String pos, String conjugationPattern, String conjugationForm)
		{
			super(pos,raw,original);

			this.reading = reading;
			this.conjugationPattern = conjugationPattern;
			this.conjugationForm = conjugationForm;
		}

		// 読み
		private String reading;
		// 活用型
		private String conjugationPattern;
		// 活用形
		private String conjugationForm;

		/**
		 * 読み
		 */
		public String getReading()
		{
            return this.reading;
		}

		/**
		 * 活用の種類。ChaSenのマニュアル等では「活用型」となっている
		 */
		public String getConjugationPattern()
		{
            return this.conjugationPattern; 
		}

		/**
		 * 活用形
		 */
		public String getConjugationForm()
		{
            return this.conjugationForm; 
		}

        /**
         * "(出現形)\t(読み)\t(原形)\t(品詞)\t(活用の種類)\t(活用形)"の形の文字列を返す 
         * @return "(出現形)\t(読み)\t(原形)\t(品詞)\t(活用の種類)\t(活用形)"の形の文字列を返す   
         */
		public String toString()
		{
			return this.getRaw() + "\t" + this.getReading() + "\t" + this.getOriginal() + "\t" + this.getPOS() + "\t" + this.getConjugationPattern() + "\t" + this.getConjugationForm();
		}


	}

